/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.handler;

import java.util.Iterator;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.compare.ide.ui.internal.EMFCompareIDEUIMessages;
import org.eclipse.emf.compare.ide.ui.internal.handler.AbstractCompareHandler;
import org.eclipse.emf.compare.ide.ui.internal.handler.SelectAncestorDialog;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;

public class CompareInDialog
extends AbstractCompareHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        IWorkbenchPart activePart = HandlerUtil.getActivePart((ExecutionEvent)event);
        ISelection currentSelection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (currentSelection instanceof IStructuredSelection) {
            Iterator iterator = ((IStructuredSelection)currentSelection).iterator();
            Notifier left = null;
            Notifier right = null;
            Notifier origin = null;
            left = (Notifier)iterator.next();
            if (iterator.hasNext()) {
                right = (Notifier)iterator.next();
            }
            if (iterator.hasNext()) {
                origin = (Notifier)iterator.next();
            }
            if (origin != null) {
                Shell shell = HandlerUtil.getActiveShell((ExecutionEvent)event);
                SelectAncestorDialog<Notifier> dialog = new SelectAncestorDialog<Notifier>(shell, (AdapterFactory)adapterFactory, new Notifier[]{left, right, origin});
                if (dialog.open() == 1) {
                    return null;
                }
                left = (Notifier)dialog.leftElement;
                right = (Notifier)dialog.rightElement;
                origin = (Notifier)dialog.originElement;
            }
            if (left instanceof EObject && right instanceof EObject && (EcoreUtil.isAncestor((EObject)((EObject)left), (EObject)((EObject)right)) || EcoreUtil.isAncestor((EObject)((EObject)right), (EObject)((EObject)left)))) {
                MessageDialog.openInformation((Shell)activePart.getSite().getShell(), (String)"EMF Compare", (String)EMFCompareIDEUIMessages.getString("CompareSelfWithAncestor"));
            } else {
                CompareEditorInput input = CompareInDialog.createCompareEditorInput(activePart, (AdapterFactory)adapterFactory, left, right, origin);
                CompareUI.openCompareDialog((CompareEditorInput)input);
            }
        }
        return null;
    }
}

