/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.overridemethods;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBase;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.internal.ui.refactoring.overridemethods.VirtualMethodContainer;

public class MethodCollector {
    private ICPPMethod[] virtualMethods(ICPPClassType clas) {
        ICPPMethod[] methods;
        ArrayList<ICPPMethod> virtualMethods = new ArrayList<ICPPMethod>();
        ICPPMethod[] iCPPMethodArray = methods = clas.getDeclaredMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPMethod method = iCPPMethodArray[n2];
            if (method.isVirtual() && !method.isDestructor() && !method.isFinal()) {
                virtualMethods.add(method);
            }
            ++n2;
        }
        return virtualMethods.toArray(new ICPPMethod[virtualMethods.size()]);
    }

    private List<ICPPClassType> getBaseClasses(ICPPClassType classType) {
        ArrayList<ICPPClassType> baseClasses = new ArrayList<ICPPClassType>();
        ICPPBase[] bases = classType.getBases();
        int i = 0;
        while (i < bases.length) {
            IBinding binding = bases[i].getBaseClass();
            if (binding instanceof ICPPClassType) {
                baseClasses.add((ICPPClassType)binding);
            }
            ++i;
        }
        return baseClasses;
    }

    private void fillContainerRecursion(VirtualMethodContainer container, ICPPClassType classType, IASTDeclSpecifier declSpecifier) {
        List<ICPPClassType> baseClasses = this.getBaseClasses(classType);
        if (baseClasses.size() == 0) {
            container.addMethodsToClass(classType, this.virtualMethods(classType), declSpecifier);
        } else {
            for (ICPPClassType baseClass : baseClasses) {
                this.fillContainerRecursion(container, baseClass, declSpecifier);
            }
            container.addMethodsToClass(classType, this.virtualMethods(classType), declSpecifier);
        }
    }

    public void fillContainer(VirtualMethodContainer container, ICPPClassType classType, IASTDeclSpecifier declSpecifier) {
        List<ICPPClassType> baseClasses = this.getBaseClasses(classType);
        if (baseClasses.size() != 0) {
            for (ICPPClassType baseClass : baseClasses) {
                this.fillContainerRecursion(container, baseClass, declSpecifier);
            }
        }
    }
}

