/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.debug.core.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.ui.IValueDetailListener;
import org.eclipse.wst.jsdt.chromium.FunctionScopeExtension;
import org.eclipse.wst.jsdt.chromium.JsArray;
import org.eclipse.wst.jsdt.chromium.JsEvaluateContext;
import org.eclipse.wst.jsdt.chromium.JsFunction;
import org.eclipse.wst.jsdt.chromium.JsObject;
import org.eclipse.wst.jsdt.chromium.JsValue;
import org.eclipse.wst.jsdt.chromium.debug.core.model.ArrayValue;
import org.eclipse.wst.jsdt.chromium.debug.core.model.EvaluateContext;
import org.eclipse.wst.jsdt.chromium.debug.core.model.ExpressionTracker;
import org.eclipse.wst.jsdt.chromium.debug.core.model.StackFrame;
import org.eclipse.wst.jsdt.chromium.debug.core.model.ValueBase;
import org.eclipse.wst.jsdt.chromium.debug.core.model.Variable;
import org.eclipse.wst.jsdt.chromium.debug.core.util.JsValueStringifier;

public class Value
extends ValueBase.ValueWithLazyVariables {
    private final JsValue value;
    private final ExpressionTracker.Node expressionNode;
    private final DetailBuilder detailBuilder = new DetailBuilder();
    private static final DetailWrapper NO_DETAILS_WRAPPER = new DetailWrapper(){

        @Override
        boolean isTruncated() {
            return false;
        }

        @Override
        JsValue getJsValue() {
            return null;
        }

        @Override
        String getStringValue() {
            return null;
        }
    };

    public static Value create(EvaluateContext evaluateContext, JsValue value, ExpressionTracker.Node expressionNode) {
        if (JsValue.Type.TYPE_ARRAY == value.getType()) {
            return new ArrayValue(evaluateContext, (JsArray)value, expressionNode);
        }
        return new Value(evaluateContext, value, expressionNode);
    }

    protected Value(EvaluateContext evaluateContext, JsValue value, ExpressionTracker.Node expressionNode) {
        super(evaluateContext);
        this.value = value;
        this.expressionNode = expressionNode;
    }

    public String getReferenceTypeName() throws DebugException {
        return this.value.getType().toString();
    }

    @Override
    public String getValueString() {
        String ref;
        String valueText = JsValueStringifier.toVisibleString(this.value);
        if (this.value.asObject() != null && (ref = this.value.asObject().getRefId()) != null) {
            valueText = String.valueOf(valueText) + "  (id=" + ref + ")";
        }
        return valueText;
    }

    @Override
    protected IVariable[] calculateVariables() {
        JsObject asObject = this.value.asObject();
        if (asObject == null) {
            return EMPTY_VARIABLES;
        }
        List<Variable> functionScopes = this.calculateFunctionScopesVariable(asObject);
        return StackFrame.wrapVariables(this.getEvaluateContext(), asObject.getProperties(), Collections.emptySet(), asObject.getInternalProperties(), functionScopes, this.expressionNode);
    }

    private List<Variable> calculateFunctionScopesVariable(JsObject jsObject) {
        JsFunction asFunction = jsObject.asFunction();
        if (asFunction == null) {
            return null;
        }
        FunctionScopeExtension functionScopeExtension = this.getConnectedData().getJavascriptVm().getFunctionScopeExtension();
        if (functionScopeExtension == null) {
            return null;
        }
        if (functionScopeExtension.getScopes(asFunction).isEmpty()) {
            return null;
        }
        Variable functionScopesVariable = Variable.forFunctionScopes(this.getEvaluateContext(), asFunction, functionScopeExtension);
        if (functionScopesVariable == null) {
            return null;
        }
        return Collections.singletonList(functionScopesVariable);
    }

    public boolean hasVariables() throws DebugException {
        return this.value.asObject() != null;
    }

    public boolean isAllocated() throws DebugException {
        return true;
    }

    @Override
    public Value asRealValue() {
        return this;
    }

    public JsValue getJsValue() {
        return this.value;
    }

    public void computeDetailAsync(IValueDetailListener listener) {
        this.detailBuilder.buildDetailAsync(listener);
    }

    public boolean isTruncated() {
        return this.value.isTruncated() || this.detailBuilder.getCurrentDetailWrapper().isTruncated();
    }

    protected ExpressionTracker.Node getExpressionTrackerNode() {
        return this.expressionNode;
    }

    public void reloadBiggerValue(ReloadValueCallback callback) {
        JsValue detailValue;
        ArrayList<JsValue> jsValueList = new ArrayList<JsValue>(2);
        if (this.value.isTruncated()) {
            jsValueList.add(this.value);
        }
        if ((detailValue = this.detailBuilder.getCurrentDetailWrapper().getJsValue()) != null && detailValue.isTruncated() && !jsValueList.contains(detailValue)) {
            jsValueList.add(detailValue);
        }
        ReloadBiggerValueProcess process = new ReloadBiggerValueProcess(callback);
        process.start(jsValueList);
    }

    private class DetailBuilder {
        private volatile DetailWrapper detailWrapper = Value.access$0();
        private static final String TO_STRING_ARGUMENT = "object";
        private static final String TO_STRING_EXPRESSION = "String(object)";

        private DetailBuilder() {
        }

        DetailWrapper getCurrentDetailWrapper() {
            return this.detailWrapper;
        }

        void buildDetailAsync(final IValueDetailListener listener) {
            DetailWrapper alreadyCalculatedDetail = this.detailWrapper;
            if (alreadyCalculatedDetail != NO_DETAILS_WRAPPER) {
                listener.detailComputed((IValue)Value.this, alreadyCalculatedDetail.getStringValue());
                return;
            }
            JsObject jsObject = Value.this.getJsValue().asObject();
            if (jsObject == null) {
                this.jsValueDetailIsBuilt(Value.this.getJsValue(), listener);
                return;
            }
            if (Value.this.getSuspendedState().isDismissed()) {
                this.stringDetailIsBuilt("", listener);
                return;
            }
            Map<String, JsObject> additionalContext = Collections.singletonMap(TO_STRING_ARGUMENT, jsObject);
            JsEvaluateContext.EvaluateCallback evaluateCallback = new JsEvaluateContext.EvaluateCallback(){

                public void success(JsEvaluateContext.ResultOrException result) {
                    result.accept((JsEvaluateContext.ResultOrException.Visitor)new JsEvaluateContext.ResultOrException.Visitor<Void>(){

                        public Void visitResult(JsValue value) {
                            DetailBuilder.this.jsValueDetailIsBuilt(value, listener);
                            return null;
                        }

                        public Void visitException(JsValue exception) {
                            DetailBuilder.this.stringDetailIsBuilt(exception.getValueString(), listener);
                            return null;
                        }
                    });
                }

                public void failure(Exception cause) {
                    DetailBuilder.this.stringDetailIsBuilt(cause.getMessage(), listener);
                }
            };
            JsEvaluateContext evaluateContext = Value.this.getSuspendedState().getDebugContext().getGlobalEvaluateContext();
            evaluateContext.evaluateAsync(TO_STRING_EXPRESSION, additionalContext, evaluateCallback, null);
        }

        private void stringDetailIsBuilt(final String detailString, IValueDetailListener listener) {
            DetailWrapper detailWrapper = new DetailWrapper(){

                @Override
                boolean isTruncated() {
                    return false;
                }

                @Override
                String getStringValue() {
                    return detailString;
                }

                @Override
                JsValue getJsValue() {
                    return null;
                }
            };
            this.detailIsBuiltImpl(detailWrapper, listener);
        }

        private void jsValueDetailIsBuilt(final JsValue detailValue, IValueDetailListener listener) {
            DetailWrapper detailWrapper = new DetailWrapper(){

                @Override
                boolean isTruncated() {
                    return detailValue.isTruncated();
                }

                @Override
                String getStringValue() {
                    return detailValue.getValueString();
                }

                @Override
                JsValue getJsValue() {
                    return detailValue;
                }
            };
            this.detailIsBuiltImpl(detailWrapper, listener);
        }

        private void detailIsBuiltImpl(DetailWrapper detailWrapper, IValueDetailListener listener) {
            this.detailWrapper = detailWrapper;
            listener.detailComputed((IValue)Value.this, detailWrapper.getStringValue());
        }
    }

    private static abstract class DetailWrapper {
        private DetailWrapper() {
        }

        abstract boolean isTruncated();

        abstract JsValue getJsValue();

        abstract String getStringValue();
    }

    private static class ReloadBiggerValueProcess {
        private final ReloadValueCallback callback;
        private int counter;
        private boolean somethingChanged;

        ReloadBiggerValueProcess(ReloadValueCallback callback) {
            this.callback = callback;
        }

        void start(List<JsValue> jsValueList) {
            if (jsValueList.isEmpty()) {
                this.callback.done(false);
                return;
            }
            this.counter = jsValueList.size();
            this.somethingChanged = false;
            for (final JsValue jsValue : jsValueList) {
                final String originalValue = jsValue.getValueString();
                jsValue.reloadHeavyValue(new JsValue.ReloadBiggerCallback(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void done() {
                        boolean weAreLast;
                        boolean somethingChangedSaved;
                        String newValueString = jsValue.getValueString();
                        boolean changed = newValueString != null && !newValueString.equals(originalValue);
                        ReloadBiggerValueProcess reloadBiggerValueProcess = this;
                        synchronized (reloadBiggerValueProcess) {
                            ReloadBiggerValueProcess reloadBiggerValueProcess2 = this;
                            reloadBiggerValueProcess2.counter = reloadBiggerValueProcess2.counter - 1;
                            ReloadBiggerValueProcess reloadBiggerValueProcess3 = this;
                            reloadBiggerValueProcess3.somethingChanged = reloadBiggerValueProcess3.somethingChanged | changed;
                            somethingChangedSaved = somethingChanged;
                            weAreLast = counter == 0;
                        }
                        if (weAreLast) {
                            callback.done(somethingChangedSaved);
                        }
                    }
                }, null);
            }
        }
    }

    public static interface ReloadValueCallback {
        public void done(boolean var1);
    }
}

