/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.property.editor;

import org.eclipse.draw2d.geometry.Point;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.editor.TextControlActionsManager;
import org.eclipse.wb.internal.core.model.property.editor.TextDisplayPropertyEditor;
import org.eclipse.wb.internal.core.model.property.table.PropertyTable;

public abstract class AbstractTextPropertyEditor
extends TextDisplayPropertyEditor {
    private Text m_textControl;
    private boolean m_ignoreFocusLost;
    private String m_currentText;

    @Override
    public boolean activate(final PropertyTable propertyTable, final Property property, Point location) throws Exception {
        this.m_textControl = new Text((Composite)propertyTable.getControl(), 0);
        new TextControlActionsManager(this.m_textControl);
        this.m_textControl.setEditable(this.isEditable());
        this.m_textControl.setFocus();
        this.m_textControl.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                try {
                    AbstractTextPropertyEditor.this.handleKeyPressed(propertyTable, property, e);
                }
                catch (Throwable ex) {
                    propertyTable.deactivateEditor(false);
                    propertyTable.handleException(ex);
                }
            }
        });
        this.m_textControl.addListener(16, event -> {
            if (!this.m_ignoreFocusLost) {
                propertyTable.deactivateEditor(true);
            }
        });
        this.toWidget(property);
        return true;
    }

    @Override
    public final void setBounds(Rectangle bounds) {
        this.m_textControl.setBounds(bounds);
    }

    @Override
    public final void deactivate(PropertyTable propertyTable, Property property, boolean save) {
        if (save) {
            try {
                if (this.m_textControl != null) {
                    this.toProperty(property);
                }
            }
            catch (Throwable e) {
                propertyTable.deactivateEditor(false);
                propertyTable.handleException(e);
            }
        }
        if (this.m_textControl != null) {
            this.m_textControl.dispose();
            this.m_textControl = null;
        }
    }

    @Override
    public void keyDown(PropertyTable propertyTable, Property property, KeyEvent event) throws Exception {
        boolean withCtrl;
        boolean withAlt = (event.stateMask & 0x10000) != 0;
        boolean bl = withCtrl = (event.stateMask & 0x40000) != 0;
        if (event.character != '\u0000' && !withAlt && !withCtrl) {
            propertyTable.activateEditor(property, null);
            AbstractTextPropertyEditor.postKeyEvent(1, event);
            AbstractTextPropertyEditor.postKeyEvent(2, event);
        }
    }

    private static void postKeyEvent(int type, KeyEvent event) {
        Event lowEvent = new Event();
        lowEvent.type = type;
        lowEvent.keyCode = event.keyCode;
        lowEvent.character = event.character;
        Display.getCurrent().post(lowEvent);
    }

    private void handleKeyPressed(PropertyTable propertyTable, Property property, KeyEvent e) throws Exception {
        if (e.keyCode == 13) {
            this.toProperty(property);
        } else if (e.keyCode == 27) {
            propertyTable.deactivateEditor(false);
        } else if (e.keyCode == 0x1000001 || e.keyCode == 0x1000002) {
            e.doit = false;
            boolean success = this.toProperty(property);
            if (!success) {
                return;
            }
            propertyTable.deactivateEditor(true);
            propertyTable.getEditDomain().navigate(e);
        }
    }

    private void toWidget(Property property) throws Exception {
        String text = this.getEditorText(property);
        if (text == null) {
            text = "";
        }
        this.m_currentText = text;
        this.m_textControl.setText(text);
        this.m_textControl.selectAll();
    }

    private boolean toProperty(Property property) throws Exception {
        String text = this.m_textControl.getText();
        if (!this.m_currentText.equals(text)) {
            this.m_ignoreFocusLost = true;
            try {
                boolean success = this.setEditorText(property, text);
                if (!success) {
                    return false;
                }
            }
            finally {
                this.m_ignoreFocusLost = false;
            }
            this.m_currentText = text;
        }
        return true;
    }

    protected boolean isEditable() {
        return true;
    }

    protected abstract String getEditorText(Property var1) throws Exception;

    protected abstract boolean setEditorText(Property var1, String var2) throws Exception;
}

