/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.table.ui.tools.internal.paperclips.border.internal;

import org.eclipse.sirius.table.ui.tools.internal.paperclips.PaperClips;
import org.eclipse.sirius.table.ui.tools.internal.paperclips.PrintIterator;
import org.eclipse.sirius.table.ui.tools.internal.paperclips.PrintPiece;
import org.eclipse.sirius.table.ui.tools.internal.paperclips.border.BorderPainter;
import org.eclipse.sirius.table.ui.tools.internal.paperclips.border.BorderPrint;
import org.eclipse.sirius.table.ui.tools.internal.paperclips.border.internal.BorderPiece;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;

public class BorderIterator
implements PrintIterator {
    private final BorderPainter border;
    private PrintIterator target;
    private boolean opened;

    public BorderIterator(BorderPrint print, Device device, GC gc) {
        this.border = print.getBorder().createPainter(device, gc);
        this.target = print.getTarget().iterator(device, gc);
        this.opened = false;
    }

    public BorderIterator(BorderIterator that) {
        this.border = that.border;
        this.target = that.target.copy();
        this.opened = that.opened;
    }

    @Override
    public boolean hasNext() {
        return this.target.hasNext();
    }

    @Override
    public Point minimumSize() {
        return this.addBorderMargin(this.target.minimumSize());
    }

    @Override
    public Point preferredSize() {
        return this.addBorderMargin(this.target.preferredSize());
    }

    private Point addBorderMargin(Point targetSize) {
        return new Point(targetSize.x + this.border.getWidth(), targetSize.y + this.border.getMaxHeight());
    }

    @Override
    public PrintPiece next(int width, int height) {
        PrintPiece piece;
        if (!this.hasNext()) {
            PaperClips.error("No more content");
        }
        if ((piece = this.next(width, height, false)) == null) {
            piece = this.next(width, height, true);
        }
        if (piece != null) {
            this.opened = true;
        }
        return piece;
    }

    private PrintPiece next(int width, int height, boolean bottomBorderOpen) {
        if ((width -= this.border.getWidth()) < 0 || (height -= this.border.getHeight(this.opened, bottomBorderOpen)) < 0) {
            return null;
        }
        PrintIterator iter = this.target.copy();
        PrintPiece piece = PaperClips.next(iter, width, height);
        if (piece == null) {
            return null;
        }
        if (bottomBorderOpen && !iter.hasNext()) {
            piece.dispose();
            piece = this.getTallestPieceNotCompletelyConsumingTarget(width, height);
            if (piece == null) {
                return null;
            }
        } else {
            if (!bottomBorderOpen && iter.hasNext()) {
                piece.dispose();
                return null;
            }
            this.target = iter;
        }
        piece = new BorderPiece(piece, this.border, this.opened, bottomBorderOpen);
        return piece;
    }

    private PrintPiece getTallestPieceNotCompletelyConsumingTarget(int width, int height) {
        int low = 0;
        int high = height - 1;
        PrintIterator bestIterator = null;
        PrintPiece bestPiece = null;
        while (low + 1 < high) {
            int testHeight = (low + high + 1) / 2;
            PrintIterator testIterator = this.target.copy();
            PrintPiece testPiece = PaperClips.next(testIterator, width, testHeight);
            if (testPiece == null) {
                low = testHeight + 1;
                continue;
            }
            if (testIterator.hasNext()) {
                low = testHeight;
                if (bestPiece != null) {
                    bestPiece.dispose();
                }
                bestIterator = testIterator;
                bestPiece = testPiece;
                continue;
            }
            high = testPiece.getSize().y - 1;
        }
        if (bestPiece != null) {
            this.target = bestIterator;
        }
        return bestPiece;
    }

    @Override
    public PrintIterator copy() {
        return new BorderIterator(this);
    }
}

