/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.core.emf;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.m2m.atl.core.IModel;
import org.eclipse.m2m.atl.core.emf.EMFModelFactory;
import org.eclipse.m2m.atl.core.emf.EMFReferenceModel;

public class EMFModel
implements IModel {
    protected EMFReferenceModel referenceModel;
    protected Map<EClass, Set<EObject>> elementsByType = new HashMap<EClass, Set<EObject>>();
    private Resource resource;
    private EMFModelFactory modelFactory;
    private boolean isTarget;

    public EMFModel(EMFReferenceModel referenceModel, EMFModelFactory mf) {
        this.referenceModel = referenceModel;
        this.modelFactory = mf;
    }

    public Object newElement(Object metaElement) {
        Resource mainResource = this.getResource();
        if (mainResource == null) {
            mainResource = this.modelFactory.getResourceSet().createResource(URI.createURI((String)"new-model"));
            this.setResource(mainResource);
        }
        EClass ec = (EClass)metaElement;
        EObject ret = null;
        ret = ec.getEPackage().getEFactoryInstance().create(ec);
        mainResource.getContents().add((Object)ret);
        return ret;
    }

    public EMFReferenceModel getReferenceModel() {
        return this.referenceModel;
    }

    public Set<EObject> getElementsByType(Object metaElement) {
        EClass ec = (EClass)metaElement;
        Set<EObject> ret = null;
        if (!this.isTarget) {
            ret = this.elementsByType.get(ec);
        }
        if (ret == null) {
            ret = new LinkedHashSet<EObject>();
            Resource res = this.getResource();
            if (res != null) {
                TreeIterator iterator = res.getAllContents();
                while (iterator.hasNext()) {
                    EObject element = (EObject)iterator.next();
                    if (!ec.isInstance((Object)element)) continue;
                    ret.add(element);
                }
            }
            if (!this.isTarget) {
                this.elementsByType.put(ec, ret);
            }
        }
        return ret;
    }

    public boolean isTarget() {
        return this.isTarget;
    }

    public void setIsTarget(boolean value) {
        this.isTarget = value;
    }

    public Resource getResource() {
        return this.resource;
    }

    protected void setResource(Resource resource) {
        this.resource = resource;
    }

    public EMFModelFactory getModelFactory() {
        return this.modelFactory;
    }

    public void commitToResource() {
        Resource res = this.getResource();
        ArrayList<EObject> toDelete = new ArrayList<EObject>();
        if (res != null) {
            TreeIterator i = res.getAllContents();
            while (i.hasNext()) {
                EObject eo = (EObject)i.next();
                if (eo.eContainer() == null) continue;
                toDelete.add(eo);
            }
            res.getContents().removeAll(toDelete);
        }
    }

    public boolean isModelOf(Object object) {
        if (this.resource == null) {
            return false;
        }
        Resource res = ((EObject)object).eResource();
        return this.getResource().equals(res);
    }

    protected void finalize() throws Throwable {
        EMFModelFactory mf = this.getModelFactory();
        if (mf != null) {
            mf.unload(this);
        }
        super.finalize();
    }
}

