/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.css2.list;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jst.pagedesigner.css2.ICSSStyle;
import org.eclipse.jst.pagedesigner.css2.list.HTMLListInfoHelper;
import org.eclipse.jst.pagedesigner.css2.list.ICounterValueGenerator;
import org.eclipse.jst.pagedesigner.css2.list.IncrementObject;
import org.eclipse.jst.pagedesigner.css2.property.ICSSPropertyMeta;

public class CounterValueGenerator
implements ICounterValueGenerator {
    private static final int DEFAULT_INITIAL_VALUE = 0;
    private static final Set STRING_TYPES = new HashSet();
    static final Set NON_STRING_TYPES = new HashSet();
    private static final int DEFAULT_INCREMENT = 1;
    private boolean _first = true;
    private Integer _initial;
    private List _visitors;
    private int _count;
    private String _identifier;
    private String _styleType;
    private String _seperator;
    private ICSSStyle _style;

    static {
        NON_STRING_TYPES.add("disc");
        NON_STRING_TYPES.add("circle");
        NON_STRING_TYPES.add("square");
        STRING_TYPES.add("decimal");
        STRING_TYPES.add("decimal-leading-zero");
        STRING_TYPES.add("lower-roman");
        STRING_TYPES.add("upper-roman");
        STRING_TYPES.add("lower-greek");
        STRING_TYPES.add("lower-alpha");
        STRING_TYPES.add("lower-latin");
        STRING_TYPES.add("upper-alpha");
        STRING_TYPES.add("upper-latin");
        STRING_TYPES.add("hebrew");
        STRING_TYPES.add("armenian");
        STRING_TYPES.add("georgian");
        STRING_TYPES.add("cjk-ideographic");
        STRING_TYPES.add("hiragana");
        STRING_TYPES.add("katakana");
        STRING_TYPES.add("hiragana-iroha");
        STRING_TYPES.add("katakana-iroha");
    }

    public CounterValueGenerator(String identifier, String styleType, String seperator, ICSSStyle style) {
        this._identifier = identifier;
        this._styleType = styleType;
        this._seperator = seperator;
        this._style = style;
        this._count = HTMLListInfoHelper.getStartInt(style) != null ? HTMLListInfoHelper.getStartInt(style) : 0;
    }

    @Override
    public String getIdentifier() {
        return this._identifier;
    }

    public String getListStyle() {
        return this._styleType;
    }

    public String getSeparator() {
        return this._seperator;
    }

    protected Object clone() throws CloneNotSupportedException {
        CounterValueGenerator newInstance = new CounterValueGenerator(this._identifier, this._styleType, this._seperator, this._style);
        return newInstance;
    }

    @Override
    public void increase(int increment) {
        if (!this._first || HTMLListInfoHelper.getStartInt(this._style) == null) {
            this._count += increment;
        }
        this._first = false;
    }

    @Override
    public void increase() {
        this.increase(1);
    }

    @Override
    public ICounterValueGenerator resetCount() {
        try {
            ICounterValueGenerator counter = (ICounterValueGenerator)this.clone();
            this._initial = null;
            this._count = HTMLListInfoHelper.getStartInt(this._style) != null ? HTMLListInfoHelper.getStartInt(this._style) : 0;
            return counter;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public int getInitial() {
        if (HTMLListInfoHelper.getStartInt(this._style) != null) {
            return HTMLListInfoHelper.getStartInt(this._style);
        }
        return this._initial != null ? this._initial : 0;
    }

    @Override
    public ICounterValueGenerator resetCount(int initial) {
        try {
            CounterValueGenerator counter = (CounterValueGenerator)this.clone();
            this._initial = new Integer(initial);
            this._count = initial;
            return counter;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    @Override
    public void setCount(Integer value) {
        if (value != null) {
            this._count = value;
            this._first = false;
        }
    }

    @Override
    public int getCurrentCount() {
        return this._count;
    }

    @Override
    public Integer getCount(Object oCaller) {
        Assert.isTrue((oCaller instanceof ICSSStyle && this._visitors != null && this._visitors.size() > 0 ? 1 : 0) != 0);
        ICSSStyle caller = (ICSSStyle)oCaller;
        if (!this._visitors.contains(caller)) {
            return null;
        }
        int result = this.getInitial();
        int i = 0;
        int n = this._visitors.size();
        while (i < n) {
            ICSSStyle style = (ICSSStyle)this._visitors.get(i);
            Object counterIncrements = style.getStyleProperty("counter-increment");
            if (counterIncrements != null && counterIncrements != ICSSPropertyMeta.NOT_SPECIFIED && counterIncrements instanceof List) {
                List crList = (List)counterIncrements;
                int j = 0;
                int nn = crList.size();
                while (j < nn) {
                    IncrementObject rObject = (IncrementObject)crList.get(j);
                    String name = rObject.getCounterName();
                    if (this.getIdentifier().equalsIgnoreCase(name)) {
                        result = rObject.getIncrement() != null ? (result += rObject.getIncrement().intValue()) : ++result;
                    }
                    ++j;
                }
            }
            if (style == caller) {
                return new Integer(result);
            }
            ++i;
        }
        return null;
    }
}

