/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.dot.internal.language.formatting;

import com.google.inject.Inject;
import java.io.IOException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.dot.internal.language.services.DotGrammarAccess;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.formatting.IElementMatcherProvider;
import org.eclipse.xtext.formatting.IIndentationInformation;
import org.eclipse.xtext.formatting.ILineSeparatorInformation;
import org.eclipse.xtext.formatting.IWhitespaceInformationProvider;
import org.eclipse.xtext.formatting.impl.AbstractDeclarativeFormatter;
import org.eclipse.xtext.formatting.impl.AbstractFormattingConfig;
import org.eclipse.xtext.formatting.impl.FormattingConfig;
import org.eclipse.xtext.formatting.impl.FormattingConfigBasedStream;
import org.eclipse.xtext.parsetree.reconstr.IHiddenTokenHelper;
import org.eclipse.xtext.parsetree.reconstr.ITokenStream;

public class DotFormatter
extends AbstractDeclarativeFormatter {
    @Inject
    private DotGrammarAccess grammarAccess;
    @Inject
    private IHiddenTokenHelper hiddenTokenHelper;
    @Inject
    private IWhitespaceInformationProvider whitespaceInformationProvider;
    private URI contextResourceURI;

    protected void configureFormatting(FormattingConfig c) {
        c.setAutoLinewrap(120);
        this.configureKeywordFormatting(c);
        this.configureGraphFormatting(c);
        this.configureSubgraphFormatting(c);
        this.configureCommentsFormatting(c);
    }

    private void configureKeywordFormatting(FormattingConfig c) {
        for (Keyword keyword : this.grammar.findKeywords(new String[]{";"})) {
            c.setNoSpace().before((EObject)keyword);
        }
        for (Keyword keyword : this.grammar.findKeywords(new String[]{","})) {
            c.setNoSpace().before((EObject)keyword);
        }
        for (Keyword keyword : this.grammar.findKeywords(new String[]{"["})) {
            c.setNoSpace().before((EObject)keyword);
        }
        for (Keyword keyword : this.grammar.findKeywords(new String[]{"="})) {
            c.setNoSpace().around((EObject)keyword);
        }
    }

    private void configureGraphFormatting(FormattingConfig c) {
        DotGrammarAccess.DotGraphElements graph = this.grammarAccess.getDotGraphAccess();
        c.setLinewrap(1, 1, 2).after((EObject)graph.getLeftCurlyBracketKeyword_3());
        c.setLinewrap().before((EObject)graph.getRightCurlyBracketKeyword_5());
        c.setIndentation((AbstractElement)graph.getLeftCurlyBracketKeyword_3(), (AbstractElement)graph.getRightCurlyBracketKeyword_5());
        c.setLinewrap(1, 1, 2).after((EObject)graph.getStmtsAssignment_4());
    }

    private void configureSubgraphFormatting(FormattingConfig c) {
        DotGrammarAccess.SubgraphElements subgraph = this.grammarAccess.getSubgraphAccess();
        c.setLinewrap(1, 1, 2).after((EObject)subgraph.getLeftCurlyBracketKeyword_2());
        c.setLinewrap().before((EObject)subgraph.getRightCurlyBracketKeyword_4());
        c.setIndentation((AbstractElement)subgraph.getLeftCurlyBracketKeyword_2(), (AbstractElement)subgraph.getRightCurlyBracketKeyword_4());
        c.setLinewrap(1, 1, 2).after((EObject)subgraph.getStmtsAssignment_3());
        c.setLinewrap(2, 2, 2).before((EObject)subgraph.getRule());
    }

    private void configureCommentsFormatting(FormattingConfig c) {
        c.setLinewrap(0, 1, 2).before((EObject)this.grammarAccess.getSL_COMMENTRule());
        c.setLinewrap(0, 1, 2).before((EObject)this.grammarAccess.getML_COMMENTRule());
        c.setLinewrap(0, 1, 1).after((EObject)this.grammarAccess.getML_COMMENTRule());
    }

    protected IIndentationInformation getIndentInfo() {
        return this.whitespaceInformationProvider.getIndentationInformation(this.contextResourceURI);
    }

    protected ILineSeparatorInformation getLineSeparatorInfo() {
        return this.whitespaceInformationProvider.getLineSeparatorInformation(this.contextResourceURI);
    }

    public ITokenStream createFormatterStream(EObject context, String indent, ITokenStream out, boolean preserveWhitespaces) {
        if (context != null && context.eResource() != null && context.eResource().getURI() != null) {
            this.contextResourceURI = EcoreUtil2.getPlatformResourceOrNormalizedURI((EObject)context).trimFragment();
        }
        return new DotFormattingConfigBasedStream(out, indent, this.getConfig(), (IElementMatcherProvider.IElementMatcher<AbstractFormattingConfig.ElementPattern>)this.createMatcher(), this.hiddenTokenHelper, preserveWhitespaces);
    }

    class DotFormattingConfigBasedStream
    extends FormattingConfigBasedStream {
        DotFormattingConfigBasedStream(ITokenStream out, String initialIndentation, FormattingConfig cfg, IElementMatcherProvider.IElementMatcher<AbstractFormattingConfig.ElementPattern> matcher, IHiddenTokenHelper hiddenTokenHelper, boolean preserveSpaces) {
            super(out, initialIndentation, cfg, matcher, hiddenTokenHelper, preserveSpaces);
        }

        public void addLineEntry(EObject grammarElement, String value, boolean isHidden) throws IOException {
            super.addLineEntry(grammarElement, value, isHidden);
        }

        void addNewLine() throws IOException {
            this.addLineEntry(null, this.getLineSeparator(), false);
        }
    }
}

