/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.multicorevisualizer.internal.utils;

import java.util.ArrayList;
import org.eclipse.cdt.dsf.gdb.multicorevisualizer.internal.utils.DebugViewUtils;
import org.eclipse.debug.internal.ui.viewers.model.provisional.TreeModelViewer;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class DebugViewTreeWalker {
    TreeModelViewer m_viewer = DebugViewUtils.getDebugViewer();

    public void dispose() {
        this.m_viewer = null;
    }

    public void walk() {
        TreePath[] roots;
        TreePath[] treePathArray = roots = this.getRootPaths();
        int n = roots.length;
        int n2 = 0;
        while (n2 < n) {
            TreePath path = treePathArray[n2];
            this.walk(path);
            ++n2;
        }
    }

    public void walk(TreePath path) {
        if (path == null) {
            return;
        }
        boolean processChildren = this.processElement(path);
        if (processChildren) {
            this.walkChildren(path);
        }
    }

    public void walkChildren(TreePath path) {
        if (path == null) {
            return;
        }
        int children = this.m_viewer.getChildCount(path);
        if (children > 0) {
            int i = 0;
            while (i < children) {
                Object child = this.m_viewer.getChildElement(path, i);
                if (child != null) {
                    TreePath childPath = path.createChildPath(child);
                    this.walk(childPath);
                }
                ++i;
            }
        }
    }

    public boolean processElement(TreePath path) {
        return true;
    }

    public TreePath[] getRootPaths() {
        ArrayList<TreePath> paths = new ArrayList<TreePath>();
        if (this.m_viewer != null) {
            TreeItem[] items;
            Tree tree = (Tree)this.m_viewer.getControl();
            TreeItem[] treeItemArray = items = tree.getItems();
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                Object root;
                TreeItem item = treeItemArray[n2];
                Object object = root = item == null ? null : item.getData();
                if (root != null) {
                    paths.add(new TreePath(new Object[]{root}));
                }
                ++n2;
            }
        }
        return paths.toArray(new TreePath[paths.size()]);
    }

    public static TreePath getChildPath(TreePath path, Object childElement) {
        return path.createChildPath(childElement);
    }

    public static Object getElement(TreePath path) {
        return path == null ? null : path.getLastSegment();
    }
}

