/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import org.apache.lucene.util.MathUtil;
import org.apache.lucene.util.Selector;

public abstract class IntroSelector
extends Selector {
    @Override
    public final void select(int from, int to, int k) {
        this.checkArgs(from, to, k);
        int maxDepth = 2 * MathUtil.log(to - from, 2);
        this.quickSelect(from, to, k, maxDepth);
    }

    int slowSelect(int from, int to, int k) {
        return this.medianOfMediansSelect(from, to - 1, k);
    }

    int medianOfMediansSelect(int left, int right, int k) {
        do {
            if (left == right) {
                return left;
            }
            int pivotIndex = this.pivot(left, right);
            if (k == (pivotIndex = this.partition(left, right, k, pivotIndex))) {
                return k;
            }
            if (k < pivotIndex) {
                right = pivotIndex - 1;
                continue;
            }
            left = pivotIndex + 1;
        } while (left != right);
        return left;
    }

    private int partition(int left, int right, int k, int pivotIndex) {
        this.setPivot(pivotIndex);
        this.swap(pivotIndex, right);
        int storeIndex = left;
        for (int i = left; i < right; ++i) {
            if (this.comparePivot(i) <= 0) continue;
            this.swap(storeIndex, i);
            ++storeIndex;
        }
        int storeIndexEq = storeIndex;
        for (int i = storeIndex; i < right; ++i) {
            if (this.comparePivot(i) != 0) continue;
            this.swap(storeIndexEq, i);
            ++storeIndexEq;
        }
        this.swap(right, storeIndexEq);
        if (k < storeIndex) {
            return storeIndex;
        }
        if (k <= storeIndexEq) {
            return k;
        }
        return storeIndexEq;
    }

    private int pivot(int left, int right) {
        if (right - left < 5) {
            int pivotIndex = this.partition5(left, right);
            return pivotIndex;
        }
        for (int i = left; i <= right; i += 5) {
            int subRight = i + 4;
            if (subRight > right) {
                subRight = right;
            }
            int median5 = this.partition5(i, subRight);
            this.swap(median5, left + (i - left) / 5);
        }
        int mid = (right - left) / 10 + left + 1;
        int to = left + (right - left) / 5;
        return this.medianOfMediansSelect(left, to, mid);
    }

    private int partition5(int left, int right) {
        for (int i = left + 1; i <= right; ++i) {
            for (int j = i; j > left && this.compare(j - 1, j) > 0; --j) {
                this.swap(j - 1, j);
            }
        }
        return left + right >>> 1;
    }

    private void quickSelect(int from, int to, int k, int maxDepth) {
        assert (from <= k);
        assert (k < to);
        if (to - from == 1) {
            return;
        }
        if (--maxDepth < 0) {
            this.slowSelect(from, to, k);
            return;
        }
        int mid = from + to >>> 1;
        if (this.compare(from, to - 1) > 0) {
            this.swap(from, to - 1);
        }
        if (this.compare(to - 1, mid) > 0) {
            this.swap(to - 1, mid);
            if (this.compare(from, to - 1) > 0) {
                this.swap(from, to - 1);
            }
        }
        this.setPivot(to - 1);
        int left = from + 1;
        int right = to - 2;
        while (true) {
            if (this.comparePivot(left) > 0) {
                ++left;
                continue;
            }
            while (left < right && this.comparePivot(right) <= 0) {
                --right;
            }
            if (left >= right) break;
            this.swap(left, right);
            --right;
        }
        this.swap(left, to - 1);
        if (left == k) {
            return;
        }
        if (left < k) {
            this.quickSelect(left + 1, to, k, maxDepth);
        } else {
            this.quickSelect(from, left, k, maxDepth);
        }
    }

    protected int compare(int i, int j) {
        this.setPivot(i);
        return this.comparePivot(j);
    }

    protected abstract void setPivot(int var1);

    protected abstract int comparePivot(int var1);
}

