/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.nativerdf.model;

import com.google.common.net.UrlEscapers;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.apache.commons.codec.binary.Hex;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.sail.nativerdf.ValueStoreRevision;
import org.eclipse.rdf4j.sail.nativerdf.model.CorruptValue;

public class CorruptIRIOrBNode
extends CorruptValue
implements IRI,
BNode {
    private static final long serialVersionUID = 3709784393454516043L;

    public CorruptIRIOrBNode(ValueStoreRevision revision, int internalID, byte[] data) {
        super(revision, internalID, data);
    }

    public String toString() {
        return this.stringValue();
    }

    @Override
    public String stringValue() {
        try {
            return this.getNamespace() + ":" + this.getLocalName();
        }
        catch (Throwable throwable) {
            return "CorruptIRIOrBNode_with_ID_" + this.getInternalID();
        }
    }

    public Value.Type getType() {
        return super.getType();
    }

    public String getNamespace() {
        return "urn:CorruptIRIOrBNode:";
    }

    public String getLocalName() {
        byte[] data = this.getData();
        if (data != null && data.length > 0) {
            String ascii;
            boolean allZero = true;
            for (byte b : data) {
                if (b == 0) continue;
                allZero = false;
                break;
            }
            if (allZero) {
                return "CORRUPT_ID_" + this.getInternalID() + "_all_" + data.length + "_data_bytes_are_0x00";
            }
            if ((data = CorruptIRIOrBNode.truncateData(data)).length > 0) {
                try {
                    String utf8 = new String(data, StandardCharsets.UTF_8);
                    if (utf8.indexOf(65533) < 0 && !utf8.trim().isEmpty()) {
                        return "CORRUPT_ID_" + this.getInternalID() + "_" + UrlEscapers.urlPathSegmentEscaper().escape(utf8);
                    }
                }
                catch (Throwable utf8) {
                    // empty catch block
                }
            }
            String recoveredUtf8 = null;
            int bestByteLen = 0;
            block5: for (int start = 0; start < data.length; ++start) {
                int candidateLen;
                for (int end = data.length; end > start && (candidateLen = end - start) > bestByteLen; --end) {
                    try {
                        String s = new String(data, start, candidateLen, StandardCharsets.UTF_8);
                        if (s.indexOf(65533) >= 0) continue;
                        recoveredUtf8 = s;
                        bestByteLen = candidateLen;
                        continue block5;
                    }
                    catch (Throwable s) {
                        // empty catch block
                    }
                }
            }
            if (recoveredUtf8 != null && !recoveredUtf8.trim().isEmpty()) {
                return "CORRUPT_ID_" + this.getInternalID() + "_" + UrlEscapers.urlPathSegmentEscaper().escape(recoveredUtf8);
            }
            int bestAsciiStart = -1;
            int bestAsciiLen = 0;
            int i = 0;
            while (i < data.length) {
                if (data[i] >= 32 && data[i] <= 126) {
                    int runStart = i;
                    while (i < data.length && data[i] >= 32 && data[i] <= 126) {
                        ++i;
                    }
                    int runLen = i - runStart;
                    if (runLen <= bestAsciiLen) continue;
                    bestAsciiLen = runLen;
                    bestAsciiStart = runStart;
                    continue;
                }
                ++i;
            }
            if (bestAsciiLen > 0 && !(ascii = new String(data, bestAsciiStart, bestAsciiLen, StandardCharsets.US_ASCII)).trim().isEmpty()) {
                return "CORRUPT_ID_" + this.getInternalID() + "_" + UrlEscapers.urlPathSegmentEscaper().escape(ascii);
            }
            return "CORRUPT_ID_" + this.getInternalID() + "_HEX_" + Hex.encodeHexString((byte[])Arrays.copyOfRange(data, 0, data.length));
        }
        return "CORRUPT_ID_" + this.getInternalID();
    }

    public String getID() {
        return "";
    }

    @Override
    public boolean equals(Object o) {
        CorruptIRIOrBNode otherCorruptValue;
        if (this == o) {
            return true;
        }
        if (o instanceof CorruptIRIOrBNode && this.getInternalID() != -1 && (otherCorruptValue = (CorruptIRIOrBNode)o).getInternalID() != -1 && this.getValueStoreRevision().equals(otherCorruptValue.getValueStoreRevision())) {
            return this.getInternalID() == otherCorruptValue.getInternalID();
        }
        return super.equals(o);
    }
}

