/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Optional;
import org.eclipse.rdf4j.common.annotation.InternalUseOnly;
import org.eclipse.rdf4j.common.exception.ValidationException;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.Rio;
import org.eclipse.rdf4j.rio.RioSetting;
import org.eclipse.rdf4j.rio.WriterConfig;
import org.eclipse.rdf4j.rio.helpers.BasicWriterSettings;
import org.eclipse.rdf4j.sail.shacl.results.ValidationReport;

@InternalUseOnly
public class ShaclSailValidationReportHelper {
    private static final WriterConfig WRITER_CONFIG = new WriterConfig();

    public static Optional<String> getValidationReportAsString(Throwable t) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ShaclSailValidationReportHelper.printValidationReport(t, (OutputStream)baos);
        String reportAsString = baos.toString();
        if (reportAsString == null || reportAsString.isBlank()) {
            return Optional.empty();
        }
        return Optional.of(reportAsString);
    }

    public static Optional<String> getValidationReportAsString(ValidationReport t) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ShaclSailValidationReportHelper.printValidationReport(t, (OutputStream)baos);
        String reportAsString = baos.toString();
        if (reportAsString == null || reportAsString.isBlank()) {
            return Optional.empty();
        }
        return Optional.of(reportAsString);
    }

    public static void printValidationReport(Throwable t, OutputStream out) {
        Optional<Model> reportOpt = ShaclSailValidationReportHelper.getValidationReport(t);
        if (reportOpt.isPresent()) {
            Rio.write((Iterable<Statement>)reportOpt.get(), out, RDFFormat.TURTLE, WRITER_CONFIG);
        }
    }

    public static void printValidationReport(ValidationReport t, OutputStream out) {
        Model model = t.asModel();
        Rio.write((Iterable<Statement>)model, out, RDFFormat.TURTLE, WRITER_CONFIG);
    }

    public static Optional<Model> getValidationReport(Throwable t) {
        for (Throwable throwable = t; throwable != null; throwable = throwable.getCause()) {
            if (!(throwable instanceof ValidationException)) continue;
            return Optional.ofNullable(((ValidationException)((Object)throwable)).validationReportAsModel());
        }
        return Optional.empty();
    }

    static {
        ((WriterConfig)WRITER_CONFIG.set((RioSetting)BasicWriterSettings.PRETTY_PRINT, (Object)true)).set((RioSetting)BasicWriterSettings.INLINE_BLANK_NODES, (Object)true);
    }
}

