/*
 * Decompiled with CFR 0.152.
 */
package no.hasmac.jsonld.expansion;

import jakarta.json.JsonNumber;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import java.util.Optional;
import no.hasmac.jsonld.JsonLdError;
import no.hasmac.jsonld.context.ActiveContext;
import no.hasmac.jsonld.context.TermDefinition;
import no.hasmac.jsonld.json.JsonProvider;
import no.hasmac.jsonld.json.JsonUtils;
import no.hasmac.jsonld.lang.DirectionType;

public final class ValueExpansion {
    private final ActiveContext activeContext;
    private Optional<TermDefinition> definition;

    private ValueExpansion(ActiveContext activeContext) {
        this.activeContext = activeContext;
    }

    public static ValueExpansion with(ActiveContext activeContext) {
        return new ValueExpansion(activeContext);
    }

    public JsonObject expand(JsonValue value, String activeProperty) throws JsonLdError {
        this.definition = this.activeContext.getTerm(activeProperty);
        Optional<String> typeMapping = this.definition.map(TermDefinition::getTypeMapping);
        if (typeMapping.isPresent()) {
            if ("@id".equals(typeMapping.get())) {
                String idValue = null;
                if (JsonUtils.isString(value)) {
                    idValue = ((JsonString)value).getString();
                } else if (this.activeContext.getOptions().isNumericId() && JsonUtils.isNumber(value)) {
                    idValue = ((JsonNumber)value).toString();
                }
                if (idValue != null) {
                    String expandedValue = this.activeContext.uriExpansion().documentRelative(true).vocab(false).expand(idValue);
                    return JsonProvider.instance().createObjectBuilder().add("@id", expandedValue).build();
                }
            } else if ("@vocab".equals(typeMapping.get()) && JsonUtils.isString(value)) {
                String expandedValue = this.activeContext.uriExpansion().documentRelative(true).vocab(true).expand(((JsonString)value).getString());
                return JsonProvider.instance().createObjectBuilder().add("@id", expandedValue).build();
            }
        }
        JsonObjectBuilder result = JsonProvider.instance().createObjectBuilder().add("@value", value);
        if (typeMapping.filter(t -> !"@id".equals(t) && !"@vocab".equals(t) && !"@none".equals(t)).isPresent()) {
            result.add("@type", typeMapping.get());
        } else if (JsonUtils.isString(value)) {
            this.buildStringValue(result);
        }
        return result.build();
    }

    private void buildStringValue(JsonObjectBuilder result) {
        JsonValue language = this.definition.map(TermDefinition::getLanguageMapping).orElseGet(() -> this.activeContext.getDefaultLanguage() != null ? JsonProvider.instance().createValue(this.activeContext.getDefaultLanguage()) : null);
        DirectionType direction = this.definition.map(TermDefinition::getDirectionMapping).orElseGet(() -> this.activeContext.getDefaultBaseDirection());
        if (JsonUtils.isNotNull(language)) {
            result.add("@language", language);
        }
        if (direction != null && !DirectionType.NULL.equals((Object)direction)) {
            result.add("@direction", (JsonValue)JsonProvider.instance().createValue(direction.name().toLowerCase()));
        }
    }
}

