/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.function.xsd;

import java.math.BigInteger;
import java.util.Optional;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.base.CoreDatatype;
import org.eclipse.rdf4j.model.datatypes.XMLDatatypeUtil;
import org.eclipse.rdf4j.query.algebra.evaluation.function.xsd.IntegerCastFunction;

public class NegativeIntegerCast
extends IntegerCastFunction {
    @Override
    protected CoreDatatype.XSD getCoreXsdDatatype() {
        return CoreDatatype.XSD.NEGATIVE_INTEGER;
    }

    @Override
    protected boolean isValidForDatatype(String lexicalValue) {
        return XMLDatatypeUtil.isValidNegativeInteger((String)lexicalValue);
    }

    @Override
    protected Optional<Literal> createTypedLiteral(ValueFactory vf, BigInteger integerValue) {
        if (integerValue.compareTo(BigInteger.ZERO) < 0) {
            return Optional.of(vf.createLiteral(integerValue.toString(), (CoreDatatype)this.getCoreXsdDatatype()));
        }
        return Optional.empty();
    }
}

