/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.federated.algebra;

import java.util.Collection;
import java.util.Set;
import org.eclipse.rdf4j.common.order.AvailableStatementOrder;
import org.eclipse.rdf4j.federated.algebra.BoundJoinTupleExpr;
import org.eclipse.rdf4j.federated.algebra.StatementTupleExpr;
import org.eclipse.rdf4j.federated.structures.QueryInfo;
import org.eclipse.rdf4j.query.algebra.AbstractQueryModelNode;
import org.eclipse.rdf4j.query.algebra.Filter;
import org.eclipse.rdf4j.query.algebra.QueryModelNode;
import org.eclipse.rdf4j.query.algebra.QueryModelVisitor;
import org.eclipse.rdf4j.query.algebra.Service;
import org.eclipse.rdf4j.query.algebra.StatementPattern;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.Union;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.query.algebra.helpers.AbstractQueryModelVisitor;

public class FedXService
extends AbstractQueryModelNode
implements TupleExpr,
BoundJoinTupleExpr {
    private static final long serialVersionUID = 7179501550561942879L;
    protected Service expr;
    protected transient QueryInfo queryInfo;
    protected boolean simple = true;
    protected int nTriples = 0;

    public FedXService(Service expr, QueryInfo queryInfo) {
        this.expr = expr;
        this.queryInfo = queryInfo;
        expr.visit(new ServiceAnalyzer());
    }

    public Service getService() {
        return this.expr;
    }

    public QueryInfo getQueryInfo() {
        return this.queryInfo;
    }

    public int getNumberOfTriplePatterns() {
        return this.nTriples;
    }

    public boolean isSimple() {
        return this.simple;
    }

    public Collection<String> getFreeVars() {
        return this.expr.getServiceVars();
    }

    public int getFreeVarCount() {
        return this.expr.getServiceVars().size();
    }

    @Override
    public <X extends Exception> void visit(QueryModelVisitor<X> visitor) throws X {
        visitor.meetOther(this);
    }

    @Override
    public <X extends Exception> void visitChildren(QueryModelVisitor<X> visitor) throws X {
        this.expr.visit(visitor);
    }

    @Override
    public void replaceChildNode(QueryModelNode current, QueryModelNode replacement) {
        if (this.expr != current) {
            throw new IllegalArgumentException("Node is not a child node: " + current);
        }
        this.expr = (Service)replacement;
    }

    @Override
    public FedXService clone() {
        return (FedXService)super.clone();
    }

    @Override
    public Set<String> getAssuredBindingNames() {
        return this.expr.getAssuredBindingNames();
    }

    @Override
    public Set<String> getBindingNames() {
        return this.expr.getBindingNames();
    }

    @Override
    public Set<Var> getSupportedOrders(AvailableStatementOrder tripleSource) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Override
    public void setOrder(Var var) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Override
    public Var getOrder() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    private class ServiceAnalyzer
    extends AbstractQueryModelVisitor<RuntimeException> {
        private ServiceAnalyzer() {
        }

        @Override
        protected void meetNode(QueryModelNode node) {
            if (node instanceof StatementTupleExpr) {
                ++FedXService.this.nTriples;
            } else if (node instanceof StatementPattern) {
                ++FedXService.this.nTriples;
            } else if (node instanceof Filter) {
                FedXService.this.simple = false;
            } else if (node instanceof Union) {
                FedXService.this.simple = false;
            }
            super.meetNode(node);
        }
    }
}

