/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.build;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.SequenceInputStream;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.core.IEditableModel;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.build.Build;
import org.eclipse.pde.internal.core.build.BuildModel;

public class WorkspaceBuildModel
extends BuildModel
implements IEditableModel {
    private static final long serialVersionUID = 1L;
    private final IFile fUnderlyingResource;
    private boolean fDirty;
    private boolean fEditable = true;

    public WorkspaceBuildModel(IFile file) {
        this.fUnderlyingResource = file;
    }

    @Override
    public void fireModelChanged(IModelChangedEvent event) {
        this.setDirty(event.getChangeType() != 99);
        super.fireModelChanged(event);
    }

    public String getContents() {
        StringWriter swriter = new StringWriter();
        PrintWriter writer = new PrintWriter(swriter);
        this.save(writer);
        return swriter.toString();
    }

    @Override
    public IResource getUnderlyingResource() {
        return this.fUnderlyingResource;
    }

    @Override
    public boolean isDirty() {
        return this.fDirty;
    }

    @Override
    public boolean isEditable() {
        return this.fEditable;
    }

    @Override
    public void load() {
        if (this.fUnderlyingResource.exists()) {
            try {
                Throwable throwable = null;
                Object var2_4 = null;
                try (InputStream stream = this.fUnderlyingResource.getContents(true);){
                    this.load(stream, false);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                PDECore.logException(e);
            }
        } else {
            this.fBuild = new Build();
            this.fBuild.setModel(this);
            this.setLoaded(true);
        }
    }

    @Override
    public boolean isInSync() {
        return true;
    }

    private String getLineDelimiter(IFile f) {
        String lineDelimiter = WorkspaceBuildModel.getLineDelimiterPreference(f);
        if (lineDelimiter == null) {
            lineDelimiter = System.lineSeparator();
        }
        return lineDelimiter;
    }

    private StringBuilder getHeaderComments(IFile f) throws IOException, CoreException {
        StringBuilder str = null;
        String lineDelimiter = this.getLineDelimiter(f);
        Throwable throwable = null;
        Object var5_6 = null;
        try (BufferedReader br = new BufferedReader(new InputStreamReader(f.getContents()));){
            String line;
            while ((line = br.readLine()) != null) {
                if (line.startsWith("#")) {
                    if (str == null) {
                        str = new StringBuilder();
                    }
                    str.append(line + lineDelimiter);
                    continue;
                }
                break;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return str;
    }

    @Override
    public void save() {
        block23: {
            if (this.fUnderlyingResource == null) {
                return;
            }
            String contents = WorkspaceBuildModel.fixLineDelimiter(this.getContents(), this.fUnderlyingResource);
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try (ByteArrayInputStream stream = new ByteArrayInputStream(contents.getBytes(StandardCharsets.ISO_8859_1));){
                    if (this.fUnderlyingResource.exists()) {
                        StringBuilder str = this.getHeaderComments(this.fUnderlyingResource);
                        if (str != null) {
                            ByteArrayInputStream headerComment = new ByteArrayInputStream(str.toString().getBytes());
                            Throwable throwable2 = null;
                            Object var8_12 = null;
                            try (SequenceInputStream totalContent = new SequenceInputStream(headerComment, stream);){
                                this.fUnderlyingResource.setContents((InputStream)totalContent, false, false, null);
                                break block23;
                            }
                            catch (Throwable throwable3) {
                                if (throwable2 == null) {
                                    throwable2 = throwable3;
                                } else if (throwable2 != throwable3) {
                                    throwable2.addSuppressed(throwable3);
                                }
                                throw throwable2;
                            }
                        }
                        this.fUnderlyingResource.setContents((InputStream)stream, false, false, null);
                        break block23;
                    }
                    this.fUnderlyingResource.create((InputStream)stream, false, null);
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable;
                }
            }
            catch (IOException | CoreException e) {
                PDECore.logException(e);
            }
        }
    }

    @Override
    public void save(PrintWriter writer) {
        this.getBuild().write("", writer);
        this.fDirty = false;
    }

    @Override
    public void setDirty(boolean dirty) {
        this.fDirty = dirty;
    }

    public void setEditable(boolean editable) {
        this.fEditable = editable;
    }

    @Override
    public String getInstallLocation() {
        return this.fUnderlyingResource.getLocation().toOSString();
    }
}

