/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.core.refactoring.resource;

import java.net.URI;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.ChangeDescriptor;
import org.eclipse.ltk.core.refactoring.resource.ResourceChange;
import org.eclipse.ltk.internal.core.refactoring.BasicElementLabels;
import org.eclipse.ltk.internal.core.refactoring.Messages;
import org.eclipse.ltk.internal.core.refactoring.RefactoringCoreMessages;
import org.eclipse.ltk.internal.core.refactoring.RefactoringCorePlugin;
import org.eclipse.ltk.internal.core.refactoring.resource.UndoDeleteResourceChange;
import org.eclipse.ltk.internal.core.refactoring.resource.undostates.ResourceUndoState;

public class DeleteResourceChange
extends ResourceChange {
    private final IPath fResourcePath;
    private final boolean fForceOutOfSync;
    private final boolean fDeleteContent;
    private ChangeDescriptor fDescriptor;

    public DeleteResourceChange(IPath resourcePath, boolean forceOutOfSync) {
        this(resourcePath, forceOutOfSync, false);
    }

    public DeleteResourceChange(IPath resourcePath, boolean forceOutOfSync, boolean deleteContent) {
        Assert.isNotNull((Object)resourcePath);
        this.fResourcePath = resourcePath;
        this.fForceOutOfSync = forceOutOfSync;
        this.fDeleteContent = deleteContent;
        this.setValidationMethod(4);
    }

    @Override
    protected IResource getModifiedResource() {
        return this.getResource();
    }

    private IResource getResource() {
        IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(this.fResourcePath);
        if (resource == null && this.fResourcePath.segmentCount() == 1) {
            resource = ResourcesPlugin.getWorkspace().getRoot().getProject(this.fResourcePath.segment(0));
        }
        return resource;
    }

    @Override
    public String getName() {
        IResource resource;
        IPath path = this.fResourcePath.makeRelative();
        StringBuilder label = new StringBuilder(Messages.format(RefactoringCoreMessages.DeleteResourceChange_name, BasicElementLabels.getPathLabel(path, false)));
        if (path.segmentCount() == 1 && (resource = this.getResource()) != null) {
            IPath location = resource.getLocation();
            if (location != null) {
                label.append(BasicElementLabels.CONCAT_STRING).append(BasicElementLabels.getPathLabel(location, true));
            } else {
                URI uri = resource.getLocationURI();
                if (uri != null) {
                    label.append(BasicElementLabels.CONCAT_STRING).append(BasicElementLabels.getURLPart(uri.toString()));
                }
            }
        }
        return label.toString();
    }

    @Override
    public Change perform(IProgressMonitor pm) throws CoreException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)pm, (String)RefactoringCoreMessages.DeleteResourceChange_deleting, (int)10);
        IResource resource = this.getResource();
        if (resource == null || !resource.exists()) {
            if (this.fDeleteContent) {
                return null;
            }
            String message = Messages.format(RefactoringCoreMessages.DeleteResourceChange_error_resource_not_exists, BasicElementLabels.getPathLabel(this.fResourcePath.makeRelative(), false));
            throw new CoreException((IStatus)new Status(4, RefactoringCorePlugin.getPluginId(), message));
        }
        if (resource.isAccessible()) {
            resource.accept(curr -> {
                try {
                    if (curr instanceof IFile) {
                        DeleteResourceChange.saveFileIfNeeded((IFile)curr, (IProgressMonitor)new NullProgressMonitor());
                    }
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
                return true;
            }, 2, false);
        }
        ResourceUndoState desc = ResourceUndoState.fromResource(resource);
        if (resource instanceof IProject) {
            ((IProject)resource).delete(this.fDeleteContent, this.fForceOutOfSync, (IProgressMonitor)subMonitor.newChild(10));
        } else {
            int updateFlags = this.fForceOutOfSync ? 3 : 2;
            resource.delete(updateFlags, (IProgressMonitor)subMonitor.newChild(5));
            desc.recordStateFromHistory(resource, (IProgressMonitor)subMonitor.newChild(5));
        }
        return new UndoDeleteResourceChange(desc);
    }

    private static void saveFileIfNeeded(IFile file, IProgressMonitor pm) throws CoreException {
        ITextFileBuffer buffer = FileBuffers.getTextFileBufferManager().getTextFileBuffer(file.getFullPath(), LocationKind.IFILE);
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)pm, (int)2);
        if (buffer != null && buffer.isDirty() && buffer.isStateValidated() && buffer.isSynchronized()) {
            buffer.commit((IProgressMonitor)subMonitor.newChild(1), false);
            file.refreshLocal(1, (IProgressMonitor)subMonitor.newChild(1));
            buffer.commit((IProgressMonitor)subMonitor.newChild(1), false);
            file.refreshLocal(1, (IProgressMonitor)subMonitor.newChild(1));
        } else {
            subMonitor.worked(2);
        }
    }

    @Override
    public ChangeDescriptor getDescriptor() {
        return this.fDescriptor;
    }

    public void setDescriptor(ChangeDescriptor descriptor) {
        this.fDescriptor = descriptor;
    }
}

