/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.plugin;

import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.pde.core.plugin.IPlugin;
import org.eclipse.pde.core.plugin.IPluginModel;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;

public class PluginReference
extends PlatformObject {
    private String fId;
    private transient IPlugin fPlugin;

    public PluginReference() {
    }

    public PluginReference(String id) {
        this.fId = id;
    }

    public PluginReference(IPlugin plugin) {
        this.fId = plugin.getId();
        this.fPlugin = plugin;
    }

    public String getId() {
        return this.fId;
    }

    public IPlugin getPlugin() {
        if (this.fPlugin == null && this.fId != null) {
            IPlugin iPlugin;
            IPluginModelBase model = this.findModel();
            if (model instanceof IPluginModel) {
                IPluginModel i = (IPluginModel)model;
                iPlugin = i.getPlugin();
            } else {
                iPlugin = null;
            }
            this.fPlugin = iPlugin;
        }
        return this.fPlugin;
    }

    protected IPluginModelBase findModel() {
        return PluginRegistry.findModel(this.fId);
    }

    public String toString() {
        if (this.fPlugin != null) {
            return this.fPlugin.getTranslatedName();
        }
        return this.fId != null ? this.fId : "?";
    }

    public boolean isResolved() {
        return this.getPlugin() != null;
    }

    public void reconnect(IPluginModelBase model) {
        IPlugin plugin = null;
        if (model instanceof IPluginModel) {
            plugin = ((IPluginModel)model).getPlugin();
        }
        this.fPlugin = plugin;
    }
}

