/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.launching.launcher;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.IStatusHandler;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.launching.PDELaunchingPlugin;
import org.eclipse.pde.internal.launching.PDEMessages;
import org.eclipse.pde.internal.launching.launcher.LaunchValidationOperation;
import org.eclipse.pde.internal.launching.launcher.RequirementHelper;

public class EclipsePluginValidationOperation
extends LaunchValidationOperation {
    public static final int CREATE_EXTENSION_ERROR_CODE = 1000;
    private static final Object[] EMPTY = new Object[0];
    private final Map<Object, Object[]> fExtensionErrors = new HashMap<Object, Object[]>(2);

    public EclipsePluginValidationOperation(ILaunchConfiguration configuration, Set<IPluginModelBase> models) {
        this(configuration, models, null);
    }

    public EclipsePluginValidationOperation(ILaunchConfiguration configuration, Set<IPluginModelBase> models, String launchMode) {
        super(configuration, models, launchMode);
    }

    @Override
    public void run(IProgressMonitor monitor) throws CoreException {
        super.run(monitor);
        if (!this.fExtensionErrors.isEmpty()) {
            this.fExtensionErrors.clear();
        }
        this.validateExtensions();
    }

    private void validateExtensions() {
        try {
            List<String> required = RequirementHelper.getApplicationLaunchRequirements(this.fLaunchConfiguration);
            for (String element : required) {
                BundleDescription bundle = this.getState().getBundle(element, null);
                if (bundle != null) continue;
                String message = NLS.bind((String)PDEMessages.EclipsePluginValidationOperation_pluginMissing, (Object)element);
                Status status = new Status(4, "org.eclipse.pde.launching", 1000, message, null);
                IStatusHandler statusHandler = DebugPlugin.getDefault().getStatusHandler((IStatus)status);
                Object extensionError = null;
                extensionError = statusHandler == null ? status.getMessage() : statusHandler.handleStatus((IStatus)status, (Object)element);
                this.fExtensionErrors.put(extensionError, EMPTY);
            }
        }
        catch (CoreException e) {
            PDELaunchingPlugin.log(e);
        }
    }

    @Override
    public boolean hasErrors() {
        return super.hasErrors() || this.fExtensionErrors.size() >= 1;
    }

    @Override
    public Map<Object, Object[]> getInput() {
        Map<Object, Object[]> map = super.getInput();
        map.putAll(this.fExtensionErrors);
        return map;
    }
}

