/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ctx.resources;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.zip.ZipInputStream;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.rcptt.core.IContextProcessor;
import org.eclipse.rcptt.core.Q7Features;
import org.eclipse.rcptt.core.scenario.Context;
import org.eclipse.rcptt.internal.core.RcpttPlugin;
import org.eclipse.rcptt.resources.WSUtils;
import org.eclipse.rcptt.resources.impl.FileBuffersUtils;
import org.eclipse.rcptt.resources.impl.WSCaptureUtils;
import org.eclipse.rcptt.resources.impl.WSOptions;
import org.eclipse.rcptt.resources.impl.WSRunnables;
import org.eclipse.rcptt.tesla.core.TeslaLimits;
import org.eclipse.rcptt.tesla.ecl.impl.UIRunnable;
import org.eclipse.rcptt.tesla.internal.ui.player.SWTUIPlayer;
import org.eclipse.rcptt.tesla.internal.ui.player.UIJobCollector;
import org.eclipse.rcptt.util.resources.ResourcesUtil;
import org.eclipse.rcptt.workspace.WSFile;
import org.eclipse.rcptt.workspace.WSFileLink;
import org.eclipse.rcptt.workspace.WSFolder;
import org.eclipse.rcptt.workspace.WSFolderLink;
import org.eclipse.rcptt.workspace.WSProject;
import org.eclipse.rcptt.workspace.WSProjectLink;
import org.eclipse.rcptt.workspace.WSRoot;
import org.eclipse.rcptt.workspace.WorkspaceContext;
import org.eclipse.rcptt.workspace.WorkspaceData;
import org.eclipse.rcptt.workspace.WorkspaceFactory;

public class WorkspaceContextProcessor
implements IContextProcessor {
    public void apply(Context context, BooleanSupplier isCancelled) throws CoreException {
        final WorkspaceContext wc = (WorkspaceContext)context;
        long stop = System.currentTimeMillis() + (long)TeslaLimits.getContextRunnableTimeout();
        final UIJobCollector collector = new UIJobCollector();
        Job.getJobManager().addJobChangeListener((IJobChangeListener)collector);
        try {
            try {
                IWorkspace ws = ResourcesPlugin.getWorkspace();
                this.disableMessageDialogsAndEnableCollector(collector);
                ws.run(WSRunnables.refreshWorkspace, null, 1, null);
                if (wc.isClearWorkspace()) {
                    this.clearWorkspace(wc, Math.toIntExact(stop - System.currentTimeMillis()), isCancelled);
                }
                ws.run(new IWorkspaceRunnable(){

                    public void run(IProgressMonitor monitor) throws CoreException {
                        WorkspaceContextProcessor.this.fit(wc.getLocation(), wc.getContent(), true);
                    }
                }, null, 1, null);
                ws.run(WSRunnables.refreshWorkspace, null, 1, null);
                UIRunnable.exec((UIRunnable)new UIRunnable<Object>(){

                    public Object run() throws CoreException {
                        collector.setNeedDisable();
                        return null;
                    }
                }, (int)Math.toIntExact(stop - System.currentTimeMillis()), (BooleanSupplier)isCancelled);
                collector.join(TeslaLimits.getContextJoinTimeout(), isCancelled);
            }
            catch (Exception e) {
                CoreException ee = new CoreException(RcpttPlugin.createStatus((String)("Failed to execute context: " + wc.getName() + " Cause: " + e.getMessage()), (Throwable)e));
                RcpttPlugin.log((Throwable)e);
                throw ee;
            }
        }
        finally {
            SWTUIPlayer.enableMessageDialogs();
            Job.getJobManager().removeJobChangeListener((IJobChangeListener)collector);
        }
    }

    private void clearWorkspace(final WorkspaceContext wc, int timeout, BooleanSupplier isCancelled) throws CoreException {
        final IWorkspace ws = ResourcesPlugin.getWorkspace();
        long stop = System.currentTimeMillis() + (long)timeout;
        UIRunnable.exec((UIRunnable)WSRunnables.closeEditorsWithResources, (int)Math.toIntExact(stop - System.currentTimeMillis()), (BooleanSupplier)isCancelled);
        UIRunnable.exec((UIRunnable)WSRunnables.clearAllFileBuffers, (int)Math.toIntExact(stop - System.currentTimeMillis()), (BooleanSupplier)isCancelled);
        UIRunnable.exec((UIRunnable)WSRunnables.clearHistory, (int)Math.toIntExact(stop - System.currentTimeMillis()), (BooleanSupplier)isCancelled);
        while (((Boolean)UIRunnable.exec((UIRunnable)WSRunnables.clearOperationHistoryEntry, (int)Math.toIntExact(stop - System.currentTimeMillis()), (BooleanSupplier)isCancelled)).booleanValue()) {
        }
        final CoreException[] ee = new CoreException[1];
        UIRunnable.exec((UIRunnable)new UIRunnable<Object>(){

            public Object run() throws CoreException {
                try {
                    ws.run(new IWorkspaceRunnable(){

                        public void run(IProgressMonitor monitor) throws CoreException {
                            WorkspaceContextProcessor.removeWorkspaceFiles(wc);
                        }
                    }, null, 1, null);
                }
                catch (CoreException e) {
                    ee[0] = e;
                }
                return null;
            }
        }, (int)Math.toIntExact(stop - System.currentTimeMillis()), (BooleanSupplier)isCancelled);
        if (ee[0] != null) {
            throw ee[0];
        }
    }

    private static void removeWorkspaceFiles(WorkspaceContext wc) throws CoreException {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject[] projects = root.getProjects();
        String contextName = wc.getName();
        String ignoredPattern = wc.getIgnoredByClearPattern();
        String[] resolveIgnoredPattern = WSOptions.resolveIgnoredPattern((String)"", (String)ignoredPattern);
        IProject[] iProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            try {
                if (!WSOptions.isIgnored((String)project.getName(), (String[])resolveIgnoredPattern)) {
                    project.delete(false, true, (IProgressMonitor)new NullProgressMonitor());
                }
            }
            catch (CoreException e) {
                throw new CoreException(WorkspaceContextProcessor.createProjectDeleteFailStatus(contextName, project.getName(), (Exception)((Object)e)));
            }
            ++n2;
        }
        IPath path = root.getLocation();
        if (path == null) {
            return;
        }
        File file = path.toFile();
        try {
            String[] ignoredPatterns = WSOptions.resolveIgnoredPattern((String)file.getPath(), (String)ignoredPattern);
            WorkspaceContextProcessor.tryDeleteFilesExceptMetadata(file, ignoredPatterns);
        }
        catch (IOException e) {
            throw new CoreException(WorkspaceContextProcessor.createContextFailStatus(contextName, e));
        }
    }

    private void disableMessageDialogsAndEnableCollector(final UIJobCollector collector) throws CoreException {
        UIRunnable.exec((UIRunnable)new UIRunnable<Object>(){

            public Object run() throws CoreException {
                SWTUIPlayer.disableMessageDialogs();
                collector.enable();
                return null;
            }
        });
    }

    public Context create(EObject param) throws CoreException {
        WorkspaceContext context = WorkspaceFactory.eINSTANCE.createWorkspaceContext();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        WSCaptureUtils.capture((IWorkspace)workspace, (WorkspaceData)context);
        return context;
    }

    private static void tryDeleteFilesExceptMetadata(File folder, String[] ignoredPatterns) throws IOException {
        ArrayList<File> undeletedResource = new ArrayList<File>();
        WorkspaceContextProcessor.deleteFilesExceptMetadata(folder, ignoredPatterns, undeletedResource, true);
        if (undeletedResource.size() > 0 && Q7Features.getInstance().isTrue("q7.contexts.workspace.clear.force.gc")) {
            System.gc();
            System.runFinalization();
            undeletedResource.clear();
            WorkspaceContextProcessor.deleteFilesExceptMetadata(folder, ignoredPatterns, undeletedResource, true);
        }
        if (undeletedResource.size() > 0) {
            StringBuilder message = new StringBuilder("Possible resource leak in AUT. Files below are locked and cannot be deleted:");
            for (File file : undeletedResource) {
                WorkspaceContextProcessor.appendFileToList(file, message);
            }
            message.append(String.format("%nExclusion patterns:", new Object[0]));
            if (ignoredPatterns == null || ignoredPatterns.length == 0) {
                message.append(String.format("%n\t<none>", new Object[0]));
            } else {
                String[] stringArray = ignoredPatterns;
                int n = ignoredPatterns.length;
                int n2 = 0;
                while (n2 < n) {
                    String pattern = stringArray[n2];
                    message.append(String.format("%n\t'%s'", pattern));
                    ++n2;
                }
            }
            throw new IOException(message.toString());
        }
    }

    private static void appendFileToList(File file, StringBuilder sb) {
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File child = fileArray[n2];
                WorkspaceContextProcessor.appendFileToList(child, sb);
                ++n2;
            }
        }
        sb.append(String.format("%n\t'%s'", file.getAbsolutePath()));
    }

    private static boolean deleteFilesExceptMetadata(File folder, String[] ignoredPatterns, List<File> undeletedResource, boolean root) {
        boolean haveIgnoredChild = false;
        File[] fileArray = folder.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.getName().equals(".metadata") && root || WSOptions.isIgnored((String)file.getPath(), (String[])ignoredPatterns)) {
                haveIgnoredChild = true;
            } else {
                boolean ignoreBecauseOfChild = false;
                if (file.isDirectory()) {
                    ignoreBecauseOfChild = WorkspaceContextProcessor.deleteFilesExceptMetadata(file, ignoredPatterns, undeletedResource, false);
                    boolean bl = haveIgnoredChild = haveIgnoredChild || ignoreBecauseOfChild;
                }
                if (!ignoreBecauseOfChild && !file.delete()) {
                    undeletedResource.add(file);
                }
            }
            ++n2;
        }
        return haveIgnoredChild;
    }

    private static IStatus createProjectDeleteFailStatus(String contextName, String projectName, Exception cause) {
        return RcpttPlugin.createStatus((String)String.format("Context '%s' failed: cannot remove project '%s' from workspace", contextName, projectName), (Throwable)cause);
    }

    private static IStatus createContextFailStatus(String contextName, Exception e) {
        return RcpttPlugin.createStatus((String)("Failed to apply context \"" + contextName + "\" caused by:\n" + e.getMessage()));
    }

    public boolean isApplied(Context context) {
        try {
            WorkspaceContext wc = (WorkspaceContext)context;
            return this.fit(wc.getLocation(), wc.getContent(), false);
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isCreateAllowed() {
        return true;
    }

    private boolean fit(String location, WSRoot root, boolean modify) throws CoreException {
        IProject rProjectFinal;
        IProject rProject;
        IWorkspaceRoot wsRoot;
        boolean success = true;
        for (WSProject project : root.getProjects()) {
            wsRoot = ResourcesPlugin.getWorkspace().getRoot();
            rProject = (IProject)ResourcesUtil.getCaseInsensitiveChild((IContainer)wsRoot, (String)project.getName(), IProject.class);
            if (rProject == null) {
                rProject = wsRoot.getProject(project.getName());
            }
            rProjectFinal = rProject;
            success &= this.fitProject(location, project, rProjectFinal, modify);
        }
        for (WSProject project : root.getProjectLinks()) {
            wsRoot = ResourcesPlugin.getWorkspace().getRoot();
            rProject = (IProject)ResourcesUtil.getCaseInsensitiveChild((IContainer)wsRoot, (String)project.getName(), IProject.class);
            if (rProject == null) {
                rProject = wsRoot.getProject(project.getName());
            }
            rProjectFinal = rProject;
            success &= this.fitProjectLink(location, (WSProjectLink)project, rProjectFinal, modify);
        }
        return success;
    }

    private boolean fitProject(String location, WSProject project, IProject rProject, boolean modify) throws CoreException {
        if (!rProject.exists()) {
            if (!modify) {
                return false;
            }
            rProject.create((IProgressMonitor)new NullProgressMonitor());
        }
        if (!rProject.isOpen()) {
            if (!modify) {
                return false;
            }
            rProject.open((IProgressMonitor)new NullProgressMonitor());
        }
        return this.fitContent(location, (WSFolder)project, (IContainer)rProject, modify);
    }

    private boolean fitProjectLink(String location, WSProjectLink project, IProject rProject, boolean modify) throws CoreException {
        if (!rProject.exists()) {
            if (!modify) {
                return false;
            }
            rProject.create((IProgressMonitor)new NullProgressMonitor());
        }
        if (!rProject.isOpen()) {
            if (!modify) {
                return false;
            }
            rProject.open((IProgressMonitor)new NullProgressMonitor());
        }
        return this.fitContent(location, (WSFolderLink)project, (IContainer)rProject, modify);
    }

    private boolean fitContent(String location, WSFolder folder, IContainer rFolder, boolean modify) throws CoreException {
        IFolder rChild;
        boolean success = true;
        for (WSFolder child : folder.getFolders()) {
            rChild = rFolder.getFolder((IPath)new Path(child.getName()));
            success &= this.fitFolder(location, child, rChild, modify);
        }
        for (WSFolder child : folder.getFolderLinks()) {
            rChild = rFolder.getFolder((IPath)new Path(child.getName()));
            success &= this.fitFolderLink(location, (WSFolderLink)child, rChild, modify);
        }
        for (WSFolder child : folder.getFiles()) {
            rChild = rFolder.getFile((IPath)new Path(child.getName()));
            success &= this.fitFile(location, (WSFile)child, (IFile)rChild, modify);
        }
        for (WSFolder child : folder.getFileLinks()) {
            rChild = rFolder.getFile((IPath)new Path(child.getName()));
            success &= this.fitFileLink(location, (WSFileLink)child, (IFile)rChild, modify);
        }
        return success;
    }

    private boolean fitContent(String location, WSFolderLink folder, IContainer rFolder, boolean modify) throws CoreException {
        IFolder rChild;
        boolean success = true;
        for (WSFolderLink child : folder.getFolders()) {
            rChild = rFolder.getFolder((IPath)new Path(child.getName()));
            success &= this.fitFolderLink(location, child, rChild, modify);
        }
        for (WSFolderLink child : folder.getFiles()) {
            rChild = rFolder.getFile((IPath)new Path(child.getName()));
            success &= this.fitFileLink(location, (WSFileLink)child, (IFile)rChild, modify);
        }
        return success;
    }

    private boolean fitFolder(String location, WSFolder folder, IFolder rFolder, boolean modify) throws CoreException {
        if (!rFolder.exists()) {
            if (!modify) {
                return false;
            }
            rFolder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
        }
        return this.fitContent(location, folder, (IContainer)rFolder, modify);
    }

    private boolean fitFolderLink(String location, WSFolderLink folder, IFolder rFolder, boolean modify) throws CoreException {
        if (!rFolder.exists()) {
            if (!modify) {
                return false;
            }
            rFolder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
        }
        return this.fitContent(location, folder, (IContainer)rFolder, modify);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean fitFile(String location, WSFile file, IFile rFile, boolean modify) throws CoreException {
        if (!rFile.exists() && !modify) {
            return false;
        }
        try {
            byte[] content = null;
            if (file.getContent() == null) {
                content = WSUtils.getFileContent((String)location, (WSFile)file);
            } else if (Q7Features.getInstance().isTrue("q7.contexts.resources.transfer.zipped")) {
                ZipInputStream zin = new ZipInputStream(new ByteArrayInputStream(file.getContent()));
                zin.getNextEntry();
                content = WSUtils.getStreamContent((InputStream)zin);
            } else {
                content = file.getContent();
            }
            ByteArrayInputStream input = new ByteArrayInputStream(content);
            if (rFile.exists()) {
                InputStream fileContent = rFile.getContents();
                try {
                    if (this.isEquals(content, fileContent)) {
                        return true;
                    }
                }
                finally {
                    WSUtils.safeClose((Closeable)fileContent);
                }
                if (!modify) {
                    return false;
                }
                rFile.setContents((InputStream)input, false, false, (IProgressMonitor)new NullProgressMonitor());
                if (file.isExecutable()) {
                    this.updateFilePermissions(rFile);
                }
                FileBuffersUtils.getFileBuffers().syncLocation(rFile.getFullPath());
                return true;
            }
            rFile.create((InputStream)input, false, (IProgressMonitor)new NullProgressMonitor());
            if (file.isExecutable()) {
                this.updateFilePermissions(rFile);
            }
            FileBuffersUtils.getFileBuffers().syncLocation(rFile.getFullPath());
            return true;
        }
        catch (IOException e) {
            Status status = new Status(4, "org.eclipse.rcptt.ctx.resources.impl", e.getMessage(), (Throwable)e);
            throw new CoreException((IStatus)status);
        }
    }

    private void updateFilePermissions(IFile rFile) {
        IPath fileLocation = rFile.getLocation();
        if (fileLocation != null) {
            File jFile = fileLocation.toFile();
            try {
                boolean result = jFile.setExecutable(true, true);
                if (!result) {
                    RcpttPlugin.log((String)String.format("Failed to set executable permission to file: %s", jFile.getAbsolutePath()), null);
                }
            }
            catch (SecurityException e) {
                RcpttPlugin.log((String)String.format("Failed to set executable permission to file: %s", jFile.getAbsolutePath()), (Throwable)e);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean fitFileLink(String location, WSFileLink fileLink, IFile rFile, boolean modify) throws CoreException {
        if (!rFile.exists() && !modify) {
            return false;
        }
        try {
            byte[] content = fileLink.getContent();
            if (Q7Features.getInstance().isTrue("q7.contexts.resources.transfer.zipped")) {
                ZipInputStream zin = new ZipInputStream(new ByteArrayInputStream(content));
                zin.getNextEntry();
                content = WSUtils.getStreamContent((InputStream)zin);
            }
            ByteArrayInputStream input = new ByteArrayInputStream(content);
            if (!rFile.exists()) {
                rFile.create((InputStream)input, false, (IProgressMonitor)new NullProgressMonitor());
                return true;
            }
            InputStream fileContent = rFile.getContents();
            try {
                if (this.isEquals(content, fileContent)) {
                    return true;
                }
            }
            finally {
                WSUtils.safeClose((Closeable)fileContent);
            }
            if (!modify) {
                return false;
            }
            rFile.setContents((InputStream)input, false, false, (IProgressMonitor)new NullProgressMonitor());
            return true;
        }
        catch (IOException e) {
            Status status = new Status(4, "org.eclipse.rcptt.ctx.resources.impl", e.getMessage(), (Throwable)e);
            throw new CoreException((IStatus)status);
        }
    }

    private boolean isEquals(byte[] content, InputStream stream) throws IOException {
        byte[] buffer = new byte[4096];
        int len = 0;
        int offset = 0;
        while ((len = stream.read(buffer)) > 0) {
            int i = 0;
            while (i < len) {
                if (buffer[i] != content[i + offset]) {
                    return false;
                }
                ++i;
            }
            offset += len;
        }
        return true;
    }
}

