/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.databinding.viewers;

import java.util.Collections;
import java.util.Set;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.IDiff;
import org.eclipse.core.databinding.observable.set.SetDiff;
import org.eclipse.core.databinding.property.INativePropertyListener;
import org.eclipse.core.databinding.property.IProperty;
import org.eclipse.core.databinding.property.ISimplePropertyListener;
import org.eclipse.core.databinding.property.NativePropertyListener;
import org.eclipse.jface.databinding.viewers.ViewerSetProperty;
import org.eclipse.jface.internal.databinding.viewers.ViewerElementSet;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckable;
import org.eclipse.jface.viewers.StructuredViewer;

public abstract class CheckboxViewerCheckedElementsProperty<S extends ICheckable, E>
extends ViewerSetProperty<S, E> {
    private final Object elementType;

    public CheckboxViewerCheckedElementsProperty(Object elementType) {
        this.elementType = elementType;
    }

    public Object getElementType() {
        return this.elementType;
    }

    protected final Set<E> createElementSet(StructuredViewer viewer) {
        return ViewerElementSet.withComparer(viewer.getComparer());
    }

    protected void doUpdateSet(S source, SetDiff<E> diff) {
        for (Object e : diff.getAdditions()) {
            source.setChecked(e, true);
        }
        for (Object e : diff.getRemovals()) {
            source.setChecked(e, false);
        }
    }

    public INativePropertyListener<S> adaptListener(ISimplePropertyListener<S, SetDiff<E>> listener) {
        return new CheckStateListener((IProperty)this, listener);
    }

    public String toString() {
        Object s = "ICheckable.checkedElements{}";
        if (this.elementType != null) {
            s = (String)s + " <" + String.valueOf(this.elementType) + ">";
        }
        return s;
    }

    private class CheckStateListener
    extends NativePropertyListener<S, SetDiff<E>>
    implements ICheckStateListener {
        private CheckStateListener(IProperty property, ISimplePropertyListener<S, SetDiff<E>> listener) {
            super(property, listener);
        }

        public void checkStateChanged(CheckStateChangedEvent event) {
            Object element = event.getElement();
            boolean checked = event.getChecked();
            Set<Object> elementSet = CheckboxViewerCheckedElementsProperty.this.createElementSet((StructuredViewer)event.getCheckable());
            elementSet.add(element);
            Set<Object> additions = checked ? elementSet : Collections.emptySet();
            Set<Object> removals = checked ? Collections.emptySet() : elementSet;
            SetDiff diff = Diffs.createSetDiff(additions, removals);
            this.fireChange((ICheckable)event.getSource(), (IDiff)diff);
        }

        public void doAddTo(S source) {
            source.addCheckStateListener((ICheckStateListener)this);
        }

        public void doRemoveFrom(S source) {
            source.removeCheckStateListener((ICheckStateListener)this);
        }
    }
}

