/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.dev.tool.docs;

import com.sun.source.doctree.DocTree;
import com.sun.source.doctree.TextTree;
import com.sun.source.doctree.UnknownBlockTagTree;
import com.sun.source.doctree.UnknownInlineTagTree;
import com.sun.source.util.SimpleDocTreeVisitor;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import jdk.javadoc.doclet.Taglet;

public abstract class ICUTaglet
implements Taglet {
    protected final String name;
    protected final boolean isInline;
    protected static final String STATUS = "<dt><span class=\"simpleTagLabel\">Status:</span></dt>";

    public abstract String toStringDocTree(DocTree var1, Element var2);

    protected ICUTaglet(String name, boolean isInline) {
        this.name = name;
        this.isInline = isInline;
    }

    @Override
    public Set<Taglet.Location> getAllowedLocations() {
        HashSet<Taglet.Location> result = new HashSet<Taglet.Location>();
        result.add(Taglet.Location.CONSTRUCTOR);
        result.add(Taglet.Location.FIELD);
        result.add(Taglet.Location.METHOD);
        result.add(Taglet.Location.MODULE);
        result.add(Taglet.Location.OVERVIEW);
        result.add(Taglet.Location.PACKAGE);
        result.add(Taglet.Location.TYPE);
        return result;
    }

    @Override
    public boolean isInlineTag() {
        return this.isInline;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String toString(List<? extends DocTree> tags, Element element) {
        if (tags != null) {
            if (tags.size() > 1) {
                Object msg = "Should not have more than one ICU tag per element:\n";
                for (int i = 0; i < tags.size(); ++i) {
                    msg = (String)msg + "  [" + i + "] " + String.valueOf(tags.get(i)) + "\n";
                }
                throw new IllegalStateException((String)msg);
            }
            if (tags.size() > 0) {
                return this.toStringDocTree(tags.get(0), element);
            }
        }
        return null;
    }

    static String getText(DocTree dt, Element element) {
        return dt.accept(new SimpleDocTreeVisitor<String, Void>(){

            @Override
            public String visitUnknownBlockTag(UnknownBlockTagTree node, Void p) {
                Iterator<? extends DocTree> iterator = node.getContent().iterator();
                if (iterator.hasNext()) {
                    DocTree dt = iterator.next();
                    return dt.accept(this, null);
                }
                return "";
            }

            @Override
            public String visitUnknownInlineTag(UnknownInlineTagTree node, Void p) {
                Iterator<? extends DocTree> iterator = node.getContent().iterator();
                if (iterator.hasNext()) {
                    DocTree dt = iterator.next();
                    return dt.accept(this, null);
                }
                return "";
            }

            @Override
            public String visitText(TextTree node, Void p) {
                return node.getBody();
            }
        }, null);
    }
}

