/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.quickaccess.providers;

import java.util.Objects;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.dialogs.PropertyDialog;
import org.eclipse.ui.quickaccess.QuickAccessElement;

public class PropertiesElement
extends QuickAccessElement {
    private final Object selectedElement;
    private final IPreferenceNode preferenceNode;

    PropertiesElement(Object selectedElement, IPreferenceNode preferenceNode) {
        this.selectedElement = selectedElement;
        this.preferenceNode = preferenceNode;
    }

    @Override
    public void execute() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null) {
            PropertyDialog dialog = PropertyDialog.createDialogOn(window.getShell(), this.preferenceNode.getId(), this.selectedElement);
            dialog.open();
        }
    }

    @Override
    public String getId() {
        return this.preferenceNode.getId();
    }

    @Override
    public ImageDescriptor getImageDescriptor() {
        Image image = this.preferenceNode.getLabelImage();
        if (image != null) {
            return ImageDescriptor.createFromImage((Image)image);
        }
        return null;
    }

    @Override
    public String getLabel() {
        return this.preferenceNode.getLabelText();
    }

    public int hashCode() {
        return Objects.hashCode(this.preferenceNode);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PropertiesElement other = (PropertiesElement)obj;
        return Objects.equals(this.preferenceNode, other.preferenceNode);
    }
}

