/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.ui.wizards;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.ui.viewer.ColumnViewerInformationControlToolTipSupport;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMIException;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IItemFontProvider;
import org.eclipse.emf.edit.ui.provider.DiagnosticDecorator;
import org.eclipse.emf.edit.ui.provider.ExtendedFontRegistry;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.ProgressMonitorPart;
import org.eclipse.oomph.p2.Requirement;
import org.eclipse.oomph.p2.core.P2Util;
import org.eclipse.oomph.setup.Argument;
import org.eclipse.oomph.setup.Installation;
import org.eclipse.oomph.setup.Macro;
import org.eclipse.oomph.setup.MacroTask;
import org.eclipse.oomph.setup.Parameter;
import org.eclipse.oomph.setup.ProductVersion;
import org.eclipse.oomph.setup.SetupPackage;
import org.eclipse.oomph.setup.SetupTaskContainer;
import org.eclipse.oomph.setup.internal.core.SetupContext;
import org.eclipse.oomph.setup.p2.util.MarketPlaceListing;
import org.eclipse.oomph.setup.provider.SetupTaskContainerItemProvider;
import org.eclipse.oomph.setup.ui.SetupUIPlugin;
import org.eclipse.oomph.setup.ui.ToolTipLabelProvider;
import org.eclipse.oomph.setup.ui.wizards.Messages;
import org.eclipse.oomph.setup.ui.wizards.SetupWizard;
import org.eclipse.oomph.ui.BackgroundProgressPart;
import org.eclipse.oomph.ui.OomphDialog;
import org.eclipse.oomph.ui.UIUtil;
import org.eclipse.oomph.util.OS;
import org.eclipse.oomph.util.StringUtil;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class MarketPlaceListingProcessor {
    protected final Shell shell;
    protected final SetupWizard setupWizard;
    protected final Resource marketPlaceListingResource;
    protected final MarketPlaceListing marketPlaceListing;
    private final MarketPlaceListingStatus status;
    private boolean hasOptionalFeatures;

    public MarketPlaceListingProcessor(SetupWizard setupWizard) {
        this.setupWizard = setupWizard;
        Resource marketPlaceListingResource = null;
        MarketPlaceListing marketPlaceListing = null;
        URI uri = URI.createURI((String)"unknown");
        for (Resource resource : setupWizard.getUnappliedConfigurationResources()) {
            uri = resource.getURI();
            if (!MarketPlaceListing.isMarketPlaceListing((URI)uri)) continue;
            marketPlaceListingResource = resource;
            marketPlaceListing = MarketPlaceListing.getMarketPlaceListing((URI)uri, (URIConverter)setupWizard.getResourceSet().getURIConverter());
            break;
        }
        this.marketPlaceListing = marketPlaceListing;
        this.marketPlaceListingResource = marketPlaceListingResource;
        this.status = new MarketPlaceListingStatus(NLS.bind((String)Messages.MarketPlaceListingProcessor_status_problemsEncountered, (Object)uri));
        this.shell = this.setupWizard.getShell();
    }

    public MarketPlaceListingProcessor(Shell shell, MarketPlaceListing marketPlaceListing, Resource marketPlaceListingResource) {
        this.marketPlaceListing = marketPlaceListing;
        this.marketPlaceListingResource = marketPlaceListingResource;
        this.shell = shell;
        this.setupWizard = null;
        this.status = new MarketPlaceListingStatus(NLS.bind((String)Messages.MarketPlaceListingProcessor_status_problemsEncountered, (Object)marketPlaceListingResource.getURI()));
    }

    public boolean isMarketPlaceListing() {
        return this.marketPlaceListing != null;
    }

    public IStatus getStatus() {
        this.status.computeSeverity();
        int okCount = 0;
        IStatus result = null;
        IStatus[] iStatusArray = this.status.getChildren();
        int n = iStatusArray.length;
        int n2 = 0;
        while (n2 < n) {
            IStatus status = iStatusArray[n2];
            if (status.isOK()) {
                ++okCount;
            } else {
                result = status;
            }
            ++n2;
        }
        if (okCount == 1) {
            return result;
        }
        return this.status;
    }

    public boolean processMarketPlaceListing() {
        if (this.marketPlaceListing == null) {
            if (this.marketPlaceListingResource != null) {
                this.status.add(this.createResourceStatus(Collections.singleton(this.marketPlaceListingResource), SetupPackage.Literals.MACRO));
            }
            return false;
        }
        if (!this.marketPlaceListingResource.getErrors().isEmpty()) {
            this.status.add(this.createResourceStatus(Collections.singleton(this.marketPlaceListingResource), SetupPackage.Literals.MACRO));
            return false;
        }
        if (this.marketPlaceListing.getUpdateSite() == null) {
            this.status.add((IStatus)new Status(4, SetupUIPlugin.PLUGIN_ID, Messages.MarketPlaceListingProcessor_status_noUpdateSiteInListing));
            return false;
        }
        if (this.marketPlaceListing.getRequirements().isEmpty()) {
            this.status.add((IStatus)new Status(4, SetupUIPlugin.PLUGIN_ID, Messages.MarketPlaceListingProcessor_status_noIusInListing));
            return false;
        }
        Point size = this.getSize();
        final LinkedHashSet<Requirement> checkedRequirements = new LinkedHashSet<Requirement>();
        OomphDialog marketPlaceListingDialog = new OomphDialog(this.shell, "", size.x, size.y, SetupUIPlugin.INSTANCE, false){
            private ProgressMonitorPart progressMonitorPart;
            private Job repositoryLoaderJob;
            private CheckboxTableViewer requirementsViewer;
            private ICheckStateListener checkStateListener;
            {
                super($anonymous0, $anonymous1, $anonymous2, $anonymous3, $anonymous4, $anonymous5);
                this.setShellStyle(85232);
            }

            protected String getShellText() {
                return Messages.MarketPlaceListingProcessor_shellText;
            }

            protected String getImagePath() {
                return "marketplace_banner.png";
            }

            protected String getDefaultMessage() {
                return Messages.MarketPlaceListingProcessor_defaultMessage;
            }

            protected void createUI(final Composite parent) {
                this.setTitle(MarketPlaceListingProcessor.this.marketPlaceListing.getLabel());
                UIUtil.asyncExec((Control)parent, (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        this.getButton(0).setEnabled(false);
                    }
                });
                List requirements = MarketPlaceListingProcessor.this.marketPlaceListing.getRequirements();
                final HashSet<Requirement> requiredRequirements = new HashSet<Requirement>();
                HashSet<Requirement> selectedRequirements = new HashSet<Requirement>();
                final LinkedHashMap installableUnits = new LinkedHashMap();
                for (Requirement requirement : requirements) {
                    installableUnits.put(requirement, null);
                    if (MarketPlaceListing.isRequired((Requirement)requirement)) {
                        requiredRequirements.add(requirement);
                        selectedRequirements.add(requirement);
                        continue;
                    }
                    if (!MarketPlaceListingProcessor.this.isSelected(requirement)) continue;
                    selectedRequirements.add(requirement);
                }
                MarketPlaceListingProcessor.this.hasOptionalFeatures = requiredRequirements.size() < requirements.size();
                this.requirementsViewer = CheckboxTableViewer.newCheckList((Composite)parent, (int)770);
                this.requirementsViewer.getTable().setLayoutData((Object)new GridData(4, 4, true, true));
                Font tableFont = this.requirementsViewer.getTable().getFont();
                Font boldFont = ExtendedFontRegistry.INSTANCE.getFont(tableFont, (Object)IItemFontProvider.BOLD_FONT);
                Font disabledFont = ExtendedFontRegistry.INSTANCE.getFont(tableFont, (Object)IItemFontProvider.ITALIC_FONT);
                Font disabledBoldFont = ExtendedFontRegistry.INSTANCE.getFont(tableFont, (Object)IItemFontProvider.BOLD_ITALIC_FONT);
                ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
                ColumnViewerInformationControlToolTipSupport toolTipSupport = new ColumnViewerInformationControlToolTipSupport((ColumnViewer)this.requirementsViewer, new LocationListener(){

                    public void changing(LocationEvent event) {
                        if (!"about:blank".equals(event.location)) {
                            OS.INSTANCE.openSystemBrowser(event.location);
                            event.doit = false;
                        }
                    }

                    public void changed(LocationEvent event) {
                    }
                });
                this.checkStateListener = new ICheckStateListener(){

                    public void checkStateChanged(CheckStateChangedEvent event) {
                        checkedRequirements.clear();
                        for (Requirement requirement : requiredRequirements) {
                            requirementsViewer.setChecked((Object)requirement, true);
                        }
                        Object[] objectArray = requirementsViewer.getCheckedElements();
                        int n = objectArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Object object = objectArray[n2];
                            if (installableUnits.get(object) != null) {
                                checkedRequirements.add((Requirement)object);
                            }
                            ++n2;
                        }
                        this.getButton(0).setEnabled(!checkedRequirements.isEmpty());
                    }
                };
                this.requirementsViewer.addCheckStateListener(this.checkStateListener);
                this.requirementsViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
                class RequirementLabelProvider
                extends ToolTipLabelProvider {
                    private final /* synthetic */ Map val$installableUnits;
                    private final /* synthetic */ Set val$requiredRequirements;
                    private final /* synthetic */ Font val$disabledBoldFont;
                    private final /* synthetic */ Font val$disabledFont;
                    private final /* synthetic */ Font val$boldFont;

                    private RequirementLabelProvider(ComposedAdapterFactory adapterFactory, ColumnViewerInformationControlToolTipSupport toolTipSupport, Map map, Set set, Font font, Font font2, Font font3) {
                        this.val$installableUnits = map;
                        this.val$requiredRequirements = set;
                        this.val$disabledBoldFont = font;
                        this.val$disabledFont = font2;
                        this.val$boldFont = font3;
                        super(adapterFactory, toolTipSupport);
                    }

                    public String getText(Object object) {
                        String name;
                        IInstallableUnit installableUnit = (IInstallableUnit)this.val$installableUnits.get(object);
                        if (installableUnit != null && (name = installableUnit.getProperty("org.eclipse.equinox.p2.name", null)) != null) {
                            return name;
                        }
                        return super.getText(object);
                    }

                    public Image getImage(Object object) {
                        Image result = super.getImage(object);
                        IInstallableUnit installableUnit = (IInstallableUnit)this.val$installableUnits.get(object);
                        if (installableUnit == null) {
                            return ExtendedImageRegistry.INSTANCE.getImage((Object)ImageDescriptor.createWithFlags((ImageDescriptor)ImageDescriptor.createFromImage((Image)result), (int)1));
                        }
                        return result;
                    }

                    public Font getFont(Object object) {
                        if (this.val$installableUnits.get(object) == null) {
                            return this.val$requiredRequirements.contains(object) ? this.val$disabledBoldFont : this.val$disabledFont;
                        }
                        return this.val$requiredRequirements.contains(object) ? this.val$boldFont : null;
                    }

                    @Override
                    public String getToolTipText(Object element) {
                        IInstallableUnit installableUnit = (IInstallableUnit)this.val$installableUnits.get(element);
                        if (installableUnit != null) {
                            String description;
                            String localBrandingImageURI = installableUnit.getProperty("org.eclipse.equinox.p2.icon");
                            String brandingSiteURI = installableUnit.getProperty("org.eclipse.equinox.p2.doc.url");
                            if (brandingSiteURI == null) {
                                brandingSiteURI = (this).MarketPlaceListingProcessor.this.marketPlaceListing.getListing().toString();
                            }
                            String label = installableUnit.getProperty("org.eclipse.equinox.p2.name", null);
                            StringBuilder result = new StringBuilder();
                            result.append("<span style='white-space: nowrap; font-size: 150%;'><b>");
                            if (brandingSiteURI != null) {
                                result.append("<a style='text-decoration: none; color: inherit;' href='");
                                result.append(brandingSiteURI);
                                result.append("'>");
                            }
                            if (localBrandingImageURI != null) {
                                result.append("<img style='padding-top: 4px;' src='");
                                result.append(localBrandingImageURI);
                                result.append("' width='42' height='42' align='absmiddle'/>&nbsp;");
                            }
                            result.append(DiagnosticDecorator.escapeContent((String)label).replace(" ", "&nbsp;"));
                            result.append("</b></span>");
                            if (brandingSiteURI != null) {
                                result.append("</a>");
                            }
                            if (!StringUtil.isEmpty((String)(description = installableUnit.getProperty("org.eclipse.equinox.p2.description", null)))) {
                                result.append("<br/>");
                                result.append("<span style='font-size: 50%;'><br/></span>");
                                result.append(description);
                                result.append("<br/>");
                            }
                            result.append("<div style='height=0px; display:none;'>&nbps;&nbps;&nbps;&nbps;&nbps;<br/><br/></br></div>");
                            return result.toString();
                        }
                        return Messages.MarketPlaceListingProcessor_tooltip_loading;
                    }
                }
                this.requirementsViewer.setLabelProvider((IBaseLabelProvider)new RequirementLabelProvider(adapterFactory, toolTipSupport, installableUnits, requiredRequirements, disabledBoldFont, disabledFont, boldFont));
                this.requirementsViewer.setInput(installableUnits.keySet());
                this.requirementsViewer.setCheckedElements(selectedRequirements.toArray());
                Composite progressArea = new Composite(parent, 2048);
                FillLayout fillLayout = new FillLayout();
                fillLayout.marginHeight = 5;
                fillLayout.marginWidth = 5;
                progressArea.setLayout((Layout)fillLayout);
                this.progressMonitorPart = new BackgroundProgressPart(progressArea, null, true);
                final GridData progressAreaGridData = new GridData(768);
                progressArea.setLayoutData((Object)progressAreaGridData);
                this.repositoryLoaderJob = new Job(Messages.MarketPlaceListingProcessor_repositoryLoaderJob_name){

                    /*
                     * Exception decompiling
                     */
                    protected IStatus run(IProgressMonitor monitor) {
                        /*
                         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                         * 
                         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [10[DOLOOP]], but top level block is 11[UNCONDITIONALDOLOOP]
                         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                         *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                         *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                         *     at org.benf.cfr.reader.Main.main(Main.java:54)
                         */
                        throw new IllegalStateException("Decompilation failed");
                    }
                };
                this.repositoryLoaderJob.schedule();
                this.progressMonitorPart.attachToCancelComponent(null);
                UIUtil.asyncExec((Control)parent, (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        requirementsViewer.setSelection((ISelection)new StructuredSelection(installableUnits.keySet().iterator().next()));
                    }
                });
            }

            private void handleRepository(IMetadataRepository repository, Map<Requirement, IInstallableUnit> requiredUnits) {
                for (Map.Entry<Requirement, IInstallableUnit> entry : requiredUnits.entrySet()) {
                    Requirement requirement = entry.getKey();
                    IQueryResult queryResult = repository.query(QueryUtil.createIUQuery((String)requirement.getName()), null);
                    Iterator iterator = P2Util.asIterable((IQueryResult)queryResult).iterator();
                    if (!iterator.hasNext()) continue;
                    IInstallableUnit installableUnit = (IInstallableUnit)iterator.next();
                    entry.setValue(installableUnit);
                }
            }

            protected void createButtonsForButtonBar(Composite parent) {
                if (MarketPlaceListingProcessor.this.hasOptionalFeatures) {
                    this.createButton(parent, 1024, Messages.MarketPlaceListingProcessor_selectAllButton_text, true);
                    this.createButton(parent, 1025, Messages.MarketPlaceListingProcessor_deselectAllButton_text, true);
                }
                super.createButtonsForButtonBar(parent);
            }

            protected void buttonPressed(int buttonId) {
                if (buttonId == 1024) {
                    this.requirementsViewer.setCheckedElements(((Collection)this.requirementsViewer.getInput()).toArray());
                    this.requirementsViewer.getTable().notifyListeners(13, new Event());
                    this.checkStateListener.checkStateChanged(null);
                } else if (buttonId == 1025) {
                    this.requirementsViewer.setCheckedElements(new Object[0]);
                    this.checkStateListener.checkStateChanged(null);
                } else {
                    super.buttonPressed(buttonId);
                }
            }

            protected void cancelPressed() {
                super.cancelPressed();
                if (this.repositoryLoaderJob != null) {
                    this.repositoryLoaderJob.cancel();
                }
            }
        };
        if (marketPlaceListingDialog.open() == 0) {
            this.applyMarketPlaceListing(checkedRequirements);
            return true;
        }
        return false;
    }

    protected boolean isSelected(Requirement requirement) {
        return MarketPlaceListing.isSelected((Requirement)requirement);
    }

    protected Point getSize() {
        Point size = this.shell.getSize();
        if (this.setupWizard == null) {
            size.x /= 2;
            size.y /= 2;
        }
        return size;
    }

    protected String getCorrespondParameterName(Requirement requirement) {
        String name = requirement.getName();
        return name.substring(0, name.length() - ".feature.group".length()) + ".enabled";
    }

    protected void applyMarketPlaceListing(Set<Requirement> checkedRequirements) {
        Installation installation = this.setupWizard.getSetupContext().getInstallation();
        SetupContext setupContext = SetupContext.create((ResourceSet)this.setupWizard.getResourceSet(), (ProductVersion)(installation == null ? null : installation.getProductVersion()));
        Installation setupInstallation = setupContext.getInstallation();
        this.applySetupTasks((SetupTaskContainer)setupInstallation, checkedRequirements);
        this.setupWizard.addAppliedConfigurationResource(this.marketPlaceListingResource);
    }

    protected void applySetupTasks(SetupTaskContainer targetSetupTaskContainer, Set<Requirement> checkedRequirements) {
        Macro macro = (Macro)EcoreUtil.getObjectByType((Collection)this.marketPlaceListingResource.getContents(), (EClassifier)SetupPackage.Literals.MACRO);
        if (macro != null) {
            MacroTask macroTask = this.createMacroTask(targetSetupTaskContainer, macro, checkedRequirements);
            EList setupTasks = targetSetupTaskContainer.getSetupTasks();
            setupTasks.add((Object)macroTask);
        }
    }

    protected MacroTask createMacroTask(SetupTaskContainer targetSetupTaskContainer, Macro macro, Set<Requirement> checkedRequirements) {
        HashSet<String> checkedParameterNames = new HashSet<String>();
        for (Requirement requirement : checkedRequirements) {
            checkedParameterNames.add(this.getCorrespondParameterName(requirement));
        }
        MacroTask macroTask = SetupTaskContainerItemProvider.createMacroTask((SetupTaskContainer)targetSetupTaskContainer, (Macro)macro);
        Iterator iterator = macroTask.getArguments().iterator();
        while (iterator.hasNext()) {
            Argument argument;
            Parameter parameter = (argument = (Argument)iterator.next()).getParameter();
            String name = parameter.getName();
            argument.setValue(checkedParameterNames.contains(name) ? "true" : "false");
        }
        return macroTask;
    }

    protected IStatus createResourceStatus(Collection<? extends Resource> resources, EClass expectedEClass) {
        StringBuilder uris = new StringBuilder();
        ArrayList<Status> childStatuses = new ArrayList<Status>();
        for (Resource resource : resources) {
            if (uris.length() != 0) {
                uris.append(' ');
            }
            uris.append(resource.getURI());
            EList errors = resource.getErrors();
            if (errors.isEmpty()) {
                EList contents = resource.getContents();
                if (contents.isEmpty()) {
                    childStatuses.add(new Status(4, SetupUIPlugin.PLUGIN_ID, Messages.MarketPlaceListingProcessor_status_emptyResource));
                    continue;
                }
                childStatuses.add(new Status(4, SetupUIPlugin.PLUGIN_ID, NLS.bind((String)Messages.MarketPlaceListingProcessor_status_resourceContains, (Object)((EObject)contents.get(0)).eClass().getName())));
                continue;
            }
            for (Resource.Diagnostic diagnostic : errors) {
                Throwable cause;
                Object message = diagnostic.getMessage();
                Throwable throwable = null;
                if (diagnostic instanceof Throwable && (throwable = (Throwable)diagnostic) instanceof XMIException && (cause = throwable.getCause()) != null) {
                    XMIException xmiException = (XMIException)throwable;
                    message = cause.getMessage();
                    int line = xmiException.getLine();
                    if (line != 0) {
                        message = (String)message + " (" + line + ", " + xmiException.getColumn() + ")";
                    }
                }
                childStatuses.add(new Status(4, SetupUIPlugin.PLUGIN_ID, (String)message, throwable));
            }
        }
        return new MultiStatus(SetupUIPlugin.PLUGIN_ID, 0, childStatuses.toArray(new IStatus[childStatuses.size()]), NLS.bind((String)Messages.MarketPlaceListingProcessor_status_couldNotLoadFromUris, (Object)expectedEClass.getName(), (Object)uris), null);
    }

    private static class MarketPlaceListingStatus
    extends MultiStatus {
        public MarketPlaceListingStatus(Resource resource) {
            super(SetupUIPlugin.PLUGIN_ID, 0, NLS.bind((String)Messages.MarketPlaceListingProcessor_MarketPlaceListingStatus_message, (Object)resource.getURI()), null);
        }

        public MarketPlaceListingStatus(String message) {
            super(SetupUIPlugin.PLUGIN_ID, 0, message, null);
        }

        public int computeSeverity() {
            IStatus[] iStatusArray = this.getChildren();
            int n = iStatusArray.length;
            int n2 = 0;
            while (n2 < n) {
                int newSev;
                IStatus status = iStatusArray[n2];
                int n3 = newSev = status instanceof MarketPlaceListingStatus ? ((MarketPlaceListingStatus)status).computeSeverity() : status.getSeverity();
                if (newSev > this.getSeverity()) {
                    this.setSeverity(newSev);
                }
                ++n2;
            }
            return this.getSeverity();
        }
    }
}

