/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.targlets.internal.core.listeners;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.URI;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.oomph.base.Annotation;
import org.eclipse.oomph.base.ModelElement;
import org.eclipse.oomph.base.util.BaseUtil;
import org.eclipse.oomph.p2.P2Factory;
import org.eclipse.oomph.p2.VersionSegment;
import org.eclipse.oomph.targlets.Targlet;
import org.eclipse.oomph.targlets.core.ITargletContainer;
import org.eclipse.oomph.targlets.core.TargletContainerEvent;
import org.eclipse.oomph.targlets.core.WorkspaceIUInfo;
import org.eclipse.oomph.targlets.internal.core.TargletsCorePlugin;
import org.eclipse.oomph.targlets.internal.core.listeners.FileUpdater;
import org.eclipse.oomph.targlets.internal.core.listeners.Messages;
import org.eclipse.oomph.targlets.internal.core.listeners.WorkspaceUpdateListener;
import org.eclipse.oomph.util.XMLUtil;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Element;

public class PomArtifactUpdater
extends WorkspaceUpdateListener {
    public static final String ANNOTATION = "http:/www.eclipse.org/oomph/targlets/PomArtifactUpdater";
    public static final String ANNOTATION_SKIP_ARTIFACT_IDS = "skipArtifactIDs";
    public static final String ANNOTATION_SKIP_VERSIONS = "skipVersions";

    @Override
    protected void handleTargletContainerEvent(TargletContainerEvent.ProfileUpdateSucceededEvent profileUpdateSucceededEvent, TargletContainerEvent.WorkspaceUpdateFinishedEvent workspaceUpdateFinishedEvent, IProgressMonitor monitor) throws Exception {
        ITargletContainer targletContainer = profileUpdateSucceededEvent.getSource();
        for (Targlet targlet : targletContainer.getTarglets()) {
            for (Annotation annotation : BaseUtil.getAnnotations((ModelElement)targlet, (String)ANNOTATION)) {
                EMap details = annotation.getDetails();
                boolean skipArtifactIDs = "true".equalsIgnoreCase((String)details.get((Object)ANNOTATION_SKIP_ARTIFACT_IDS));
                boolean skipVersions = "true".equalsIgnoreCase((String)details.get((Object)ANNOTATION_SKIP_VERSIONS));
                if (skipArtifactIDs && skipVersions) continue;
                Map<IInstallableUnit, WorkspaceIUInfo> workspaceIUInfos = profileUpdateSucceededEvent.getWorkspaceIUInfos();
                PomArtifactUpdater.updatePomArtifacts(skipArtifactIDs, skipVersions, workspaceIUInfos, monitor);
            }
        }
    }

    private static void updatePomArtifacts(final boolean skipArtifactIDs, final boolean skipVersions, Map<IInstallableUnit, WorkspaceIUInfo> workspaceIUInfos, final IProgressMonitor monitor) throws Exception {
        final DocumentBuilder documentBuilder = XMLUtil.createDocumentBuilder();
        monitor.subTask(Messages.PomArtifactUpdater_Checking_task);
        for (Map.Entry<IInstallableUnit, WorkspaceIUInfo> entry : workspaceIUInfos.entrySet()) {
            TargletsCorePlugin.checkCancelation((IProgressMonitor)monitor);
            final IInstallableUnit iu = entry.getKey();
            WorkspaceIUInfo info = entry.getValue();
            File folder = info.getLocation();
            final File pom = new File(folder, "pom.xml");
            if (!pom.isFile()) continue;
            new FileUpdater(){

                @Override
                protected String createNewContents(String oldContents, String encoding, String nl) {
                    try {
                        String newContents = oldContents;
                        Element rootElement = XMLUtil.loadRootElement((DocumentBuilder)documentBuilder, (File)pom);
                        if (!skipArtifactIDs) {
                            String newID = iu.getId();
                            if (newID.endsWith(".feature.group")) {
                                newID = newID.substring(0, newID.length() - ".feature.group".length());
                            } else if (newID.endsWith(".plain.project")) {
                                newID = newID.substring(0, newID.length() - ".plain.project".length());
                            }
                            XMLUtil.ElementUpdater artifactIDUpdater = new XMLUtil.ElementUpdater(rootElement, "artifactId");
                            newContents = artifactIDUpdater.update(newContents, newID);
                        }
                        if (!skipVersions) {
                            VersionRange versionRange = P2Factory.eINSTANCE.createVersionRange(iu.getVersion(), VersionSegment.MICRO);
                            String newVersion = String.valueOf(versionRange.getMinimum()) + "-SNAPSHOT";
                            XMLUtil.ElementUpdater versionUpdater = new XMLUtil.ElementUpdater(rootElement, "version");
                            newContents = versionUpdater.update(newContents, newVersion);
                        }
                        return newContents;
                    }
                    catch (RuntimeException ex) {
                        throw ex;
                    }
                    catch (Exception ex) {
                        throw new RuntimeException(ex);
                    }
                }

                @Override
                protected void setContents(URI uri, String encoding, String contents) throws IOException {
                    monitor.subTask(NLS.bind((String)Messages.PomArtifactUpdater_Updating_task, (Object)(uri.isPlatformResource() ? uri.toPlatformString(true) : uri.toFileString())));
                    super.setContents(uri, encoding, contents);
                }
            }.update(pom);
        }
    }
}

