/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.set.mutable.primitive;

import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.iterator.MutableLongIterator;
import org.eclipse.collections.api.set.MutableSet;
import org.eclipse.collections.api.set.ParallelUnsortedSetIterable;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.impl.set.mutable.AbstractMutableSet;

public class BoxedMutableLongSet
extends AbstractMutableSet<Long>
implements MutableSet<Long> {
    private final MutableLongSet delegate;

    public BoxedMutableLongSet(MutableLongSet delegate) {
        this.delegate = Objects.requireNonNull(delegate);
    }

    public int size() {
        return this.delegate.size();
    }

    public Long getFirst() {
        throw new UnsupportedOperationException();
    }

    public Long getLast() {
        throw new UnsupportedOperationException();
    }

    public void each(Procedure<? super Long> procedure) {
        this.delegate.each(arg_0 -> procedure.value(arg_0));
    }

    @Override
    public boolean add(Long item) {
        return this.delegate.add(item.longValue());
    }

    @Override
    public boolean contains(Object object) {
        return object instanceof Long && this.delegate.contains(((Long)object).longValue());
    }

    @Override
    public boolean remove(Object object) {
        return object instanceof Long && this.delegate.remove(((Long)object).longValue());
    }

    public void clear() {
        this.delegate.clear();
    }

    public ParallelUnsortedSetIterable<Long> asParallel(ExecutorService executorService, int batchSize) {
        throw new UnsupportedOperationException();
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Set)) {
            return false;
        }
        Set other = (Set)object;
        return this.size() == other.size() && this.containsAll(other);
    }

    public Iterator<Long> iterator() {
        return new BoxedPrimitiveLongSetIterator(this.delegate.longIterator());
    }

    private static final class BoxedPrimitiveLongSetIterator
    implements Iterator<Long> {
        private final MutableLongIterator delegate;

        private BoxedPrimitiveLongSetIterator(MutableLongIterator iterator) {
            this.delegate = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public Long next() {
            return this.delegate.next();
        }
    }
}

