/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.lazy.primitive;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Iterator;
import org.eclipse.collections.api.FloatIterable;
import org.eclipse.collections.api.LazyIterable;
import org.eclipse.collections.api.bag.primitive.MutableFloatBag;
import org.eclipse.collections.api.block.function.primitive.FloatFunction;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.block.predicate.primitive.FloatPredicate;
import org.eclipse.collections.api.block.procedure.Procedure2;
import org.eclipse.collections.api.block.procedure.primitive.FloatProcedure;
import org.eclipse.collections.api.block.procedure.primitive.ObjectIntProcedure;
import org.eclipse.collections.api.factory.primitive.FloatBags;
import org.eclipse.collections.api.factory.primitive.FloatLists;
import org.eclipse.collections.api.factory.primitive.FloatSets;
import org.eclipse.collections.api.iterator.FloatIterator;
import org.eclipse.collections.api.list.primitive.MutableFloatList;
import org.eclipse.collections.api.set.primitive.MutableFloatSet;
import org.eclipse.collections.impl.lazy.primitive.AbstractLazyFloatIterable;

public class CollectFloatIterable<T>
extends AbstractLazyFloatIterable {
    private final LazyIterable<T> iterable;
    private final FloatFunction<? super T> function;
    private final FloatFunctionToProcedure<T> floatFunctionToProcedure;

    public CollectFloatIterable(LazyIterable<T> adapted, FloatFunction<? super T> function) {
        this.iterable = adapted;
        this.function = function;
        this.floatFunctionToProcedure = new FloatFunctionToProcedure<T>(function);
    }

    public FloatIterator floatIterator() {
        return new FloatIterator(){
            private final Iterator<T> iterator;
            {
                this.iterator = CollectFloatIterable.this.iterable.iterator();
            }

            public float next() {
                return CollectFloatIterable.this.function.floatValueOf(this.iterator.next());
            }

            public boolean hasNext() {
                return this.iterator.hasNext();
            }
        };
    }

    public void each(FloatProcedure procedure) {
        this.iterable.forEachWith(this.floatFunctionToProcedure, (Object)procedure);
    }

    @Override
    public int size() {
        return this.iterable.size();
    }

    @Override
    public boolean isEmpty() {
        return this.iterable.isEmpty();
    }

    @Override
    public boolean notEmpty() {
        return this.iterable.notEmpty();
    }

    @Override
    public int count(FloatPredicate predicate) {
        return this.iterable.count((Predicate & Serializable)each -> predicate.accept(this.function.floatValueOf(each)));
    }

    @Override
    public boolean anySatisfy(FloatPredicate predicate) {
        return this.iterable.anySatisfy((Predicate & Serializable)each -> predicate.accept(this.function.floatValueOf(each)));
    }

    @Override
    public boolean allSatisfy(FloatPredicate predicate) {
        return this.iterable.allSatisfy((Predicate & Serializable)each -> predicate.accept(this.function.floatValueOf(each)));
    }

    @Override
    public float[] toArray() {
        float[] array = new float[this.size()];
        this.iterable.forEachWithIndex((ObjectIntProcedure & Serializable)(each, index) -> {
            array[index] = this.function.floatValueOf(each);
        });
        return array;
    }

    @Override
    public float[] toSortedArray() {
        float[] array = this.toArray();
        Arrays.sort(array);
        return array;
    }

    @Override
    public MutableFloatList toList() {
        return FloatLists.mutable.withAll((FloatIterable)this);
    }

    @Override
    public MutableFloatSet toSet() {
        return FloatSets.mutable.withAll((FloatIterable)this);
    }

    @Override
    public MutableFloatBag toBag() {
        return FloatBags.mutable.withAll((FloatIterable)this);
    }

    @Override
    public boolean containsAll(float ... source) {
        for (float value : source) {
            if (this.contains(value)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsAll(FloatIterable source) {
        FloatIterator iterator = source.floatIterator();
        while (iterator.hasNext()) {
            if (this.contains(iterator.next())) continue;
            return false;
        }
        return true;
    }

    private static final class FloatFunctionToProcedure<T>
    implements Procedure2<T, FloatProcedure> {
        private static final long serialVersionUID = 1L;
        private final FloatFunction<? super T> function;

        private FloatFunctionToProcedure(FloatFunction<? super T> function) {
            this.function = function;
        }

        public void value(T each, FloatProcedure procedure) {
            procedure.value(this.function.floatValueOf(each));
        }
    }
}

