/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.evaluator;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.m2m.internal.qvt.oml.QvtPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QvtRuntimeException
extends RuntimeException {
    private static final long serialVersionUID = -8903219155434276631L;
    private List<StackTraceElement> fStackTrace;

    public QvtRuntimeException() {
    }

    public QvtRuntimeException(String message) {
        super(message);
    }

    public QvtRuntimeException(Throwable cause) {
        super(cause);
    }

    public QvtRuntimeException(String message, Throwable cause) {
        super(message, cause);
    }

    public static void doThrow(QvtRuntimeException exception, StackInfoProvider stackInfoProvider) throws QvtRuntimeException {
        try {
            exception.setStackQvtTrace(stackInfoProvider.getStackTraceElements());
        }
        catch (Exception e) {
            QvtPlugin.log(QvtPlugin.createErrorStatus("Failed to build QVT stack trace", e));
        }
        throw exception;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printQvtStackTrace(PrintWriter pw) {
        PrintWriter printWriter = pw;
        synchronized (printWriter) {
            pw.println(this);
            for (StackTraceElement trace : this.getQvtStackTrace()) {
                pw.println("\tat " + trace);
            }
        }
    }

    public List<StackTraceElement> getQvtStackTrace() {
        if (this.fStackTrace != null) {
            return Collections.unmodifiableList(this.fStackTrace);
        }
        return Collections.emptyList();
    }

    void setStackQvtTrace(List<StackTraceElement> stackTrace) {
        this.fStackTrace = null;
        if (stackTrace != null) {
            this.fStackTrace = new ArrayList<StackTraceElement>(stackTrace);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface StackInfoProvider {
        public List<StackTraceElement> getStackTraceElements();
    }
}

