/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.domain.services.properties;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.papyrus.uml.domain.services.IEditableChecker;
import org.eclipse.papyrus.uml.domain.services.create.CreationStatus;
import org.eclipse.papyrus.uml.domain.services.create.ElementCreator;
import org.eclipse.papyrus.uml.domain.services.destroy.DestroyerStatus;
import org.eclipse.papyrus.uml.domain.services.destroy.ElementDestroyer;
import org.eclipse.papyrus.uml.domain.services.modify.ElementFeatureModifier;
import org.eclipse.papyrus.uml.domain.services.properties.ILogger;
import org.eclipse.papyrus.uml.domain.services.status.State;
import org.eclipse.papyrus.uml.domain.services.status.Status;

public class PropertiesCrudServices {
    private final ILogger logger;
    private final IEditableChecker checker;

    public PropertiesCrudServices(ILogger logger, IEditableChecker checker) {
        this.logger = logger;
        this.checker = checker;
    }

    public EObject removeFromUsingIndex(EObject self, String featureName, Integer index) {
        EStructuralFeature feature = self.eClass().getEStructuralFeature(featureName);
        if (feature == null || !feature.isMany() || !feature.isChangeable()) {
            this.logger.log("Invalid feature " + featureName + " on " + this.logger.getLabelForLog(self), ILogger.ILogLevel.ERROR);
        } else {
            List list = (List)self.eGet(feature);
            if (list.size() > index) {
                Object valueToRemove = list.get(index);
                ECrossReferenceAdapter crossReferenceAdapter = ECrossReferenceAdapter.getCrossReferenceAdapter((Notifier)self);
                Status status = new ElementFeatureModifier(crossReferenceAdapter, this.checker).removeValue(self, featureName, valueToRemove);
                if (status.getState() == State.FAILED) {
                    this.logger.log(status.getMessage(), ILogger.ILogLevel.ERROR);
                }
            }
        }
        return self;
    }

    public EObject addToAttribute(EObject self, String featureName, String value) {
        EStructuralFeature feature = self.eClass().getEStructuralFeature(featureName);
        if (feature == null || !(feature instanceof EAttribute) || !feature.isMany()) {
            this.logger.log("Invalid feature " + featureName + " : Expecting a multivalued feature", ILogger.ILogLevel.ERROR);
            return self;
        }
        EAttribute attr = (EAttribute)feature;
        EDataType eAttributeType = attr.getEAttributeType();
        try {
            Object newValue = eAttributeType.getEPackage().getEFactoryInstance().createFromString(eAttributeType, value);
            if (newValue != null) {
                ECrossReferenceAdapter crossReferenceAdapter = ECrossReferenceAdapter.getCrossReferenceAdapter((Notifier)self);
                ElementFeatureModifier elementFeatureModifier = new ElementFeatureModifier(crossReferenceAdapter, this.checker);
                Status status = elementFeatureModifier.addValue(self, featureName, newValue);
                if (status.getState() == State.FAILED) {
                    this.logger.log(status.getMessage(), ILogger.ILogLevel.ERROR);
                }
            } else {
                this.logger.log("Invalid value for feature " + featureName + " expecting a " + eAttributeType.getName(), ILogger.ILogLevel.ERROR);
            }
        }
        catch (IllegalArgumentException e) {
            this.logger.log("Invalid value for feature " + featureName + " expecting a " + eAttributeType.getName() + " : " + e.getMessage(), ILogger.ILogLevel.ERROR);
        }
        return self;
    }

    public boolean delete(Object selectedObject, EObject target, String refName) {
        boolean isDeleted = false;
        if (selectedObject instanceof EObject) {
            EObject objectToRemove = (EObject)selectedObject;
            ECrossReferenceAdapter crossReferenceAdapter = ECrossReferenceAdapter.getCrossReferenceAdapter((Notifier)objectToRemove);
            EReference eReference = this.getReference(target, refName);
            if (eReference == null || eReference.isContainment()) {
                ElementDestroyer destroyer = ElementDestroyer.buildDefault(crossReferenceAdapter, this.checker);
                DestroyerStatus destroyerStatus = destroyer.destroy(objectToRemove);
                if (destroyerStatus.getState() == State.FAILED) {
                    this.logger.log(this.logger.getLabelForLog(objectToRemove) + " cannot be deleted.", ILogger.ILogLevel.ERROR);
                } else {
                    isDeleted = true;
                }
            } else {
                ElementFeatureModifier modifier = new ElementFeatureModifier(crossReferenceAdapter, this.checker);
                Status removeValueStatus = null;
                removeValueStatus = !eReference.isMany() ? modifier.setValue(target, refName, null) : modifier.removeValue(target, refName, objectToRemove);
                if (State.DONE == removeValueStatus.getState()) {
                    isDeleted = true;
                } else {
                    this.logger.log(removeValueStatus.getMessage(), ILogger.ILogLevel.ERROR);
                }
            }
        }
        return isDeleted;
    }

    public EObject create(EObject target, String typeName, String refName) {
        EObject createdElement = null;
        if (this.getReference(target, refName) != null) {
            ECrossReferenceAdapter crossReferenceAdapter = ECrossReferenceAdapter.getCrossReferenceAdapter((Notifier)target);
            ElementCreator ec = ElementCreator.buildDefault(crossReferenceAdapter, this.checker);
            CreationStatus status = ec.create(target, typeName, refName);
            if (status.getState() == State.FAILED) {
                this.logger.log(status.getMessage(), ILogger.ILogLevel.ERROR);
            }
            createdElement = status.getElement();
        }
        return createdElement;
    }

    public boolean updateReference(EObject target, Object objectToSet, String refName) {
        EReference eReference;
        boolean isUpdated = false;
        if (target != null && (eReference = this.getReference(target, refName)) != null && !eReference.isContainment()) {
            if (objectToSet instanceof List && eReference.isMany()) {
                isUpdated = this.set(target, refName, objectToSet);
            } else if (objectToSet instanceof EObject) {
                EObject eObject = (EObject)objectToSet;
                ECrossReferenceAdapter crossReferenceAdapter = ECrossReferenceAdapter.getCrossReferenceAdapter((Notifier)eObject);
                ElementFeatureModifier modifier = new ElementFeatureModifier(crossReferenceAdapter, this.checker);
                isUpdated = modifier.addValue(target, refName, eObject).getState() == State.DONE;
            }
        }
        return isUpdated;
    }

    public boolean set(EObject target, String refName, Object valueToSet) {
        boolean isSetted = false;
        EReference eReference = this.getReference(target, refName);
        if (target != null) {
            isSetted = eReference != null && valueToSet instanceof List && eReference.isMany() ? this.setNewList(target, (List)valueToSet, refName) : this.setUnary(target, refName, valueToSet);
        }
        return isSetted;
    }

    private boolean setNewList(EObject target, List<EObject> listToSet, String refName) {
        boolean isSetted = true;
        ECrossReferenceAdapter crossReferenceAdapter = new ECrossReferenceAdapter();
        ElementFeatureModifier modifier = new ElementFeatureModifier(crossReferenceAdapter, this.checker);
        EReference eReference = this.getReference(target, refName);
        Object ref = target.eGet((EStructuralFeature)eReference);
        ArrayList oldRef = new ArrayList();
        oldRef.addAll((List)ref);
        for (EObject o : oldRef) {
            if (listToSet.contains(o)) continue;
            modifier.removeValue(target, refName, o);
        }
        ((List)ref).clear();
        for (EObject o : listToSet) {
            if (oldRef.contains(o)) {
                PropertiesCrudServices.addToContainer(target, (EStructuralFeature)eReference, o);
                continue;
            }
            if (!isSetted) continue;
            Status status = modifier.addValue(target, refName, o);
            State state = status.getState();
            if (state == State.FAILED) {
                this.logger.log(status.getMessage(), ILogger.ILogLevel.ERROR);
            }
            boolean bl = isSetted = isSetted && state == State.DONE;
        }
        return isSetted;
    }

    private static void addToContainer(EObject container, EStructuralFeature eStructuralFeature, Object value) {
        Objects.requireNonNull(container);
        Objects.requireNonNull(eStructuralFeature);
        if (FeatureMapUtil.isMany((EObject)container, (EStructuralFeature)eStructuralFeature)) {
            List list = (List)container.eGet(eStructuralFeature);
            list.add(value);
        } else {
            container.eSet(eStructuralFeature, value);
        }
    }

    private boolean setUnary(EObject elementToUpdate, String featureName, Object newValue) {
        ECrossReferenceAdapter crossReferenceAdapter = ECrossReferenceAdapter.getCrossReferenceAdapter((Notifier)elementToUpdate);
        ElementFeatureModifier elementFeatureModifier = new ElementFeatureModifier(crossReferenceAdapter, this.checker);
        Status setSatus = elementFeatureModifier.setValue(elementToUpdate, featureName, newValue);
        State state = setSatus.getState();
        if (state == State.FAILED) {
            this.logger.log(setSatus.getMessage(), ILogger.ILogLevel.ERROR);
        }
        return state == State.DONE;
    }

    private EReference getReference(EObject target, String refName) {
        EStructuralFeature eStructuralFeature;
        EReference eReference = null;
        if (target != null && refName != null && !refName.isBlank() && (eStructuralFeature = target.eClass().getEStructuralFeature(refName)) instanceof EReference) {
            eReference = (EReference)eStructuralFeature;
        }
        return eReference;
    }
}

