/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.search.action;

import java.util.Comparator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.search.CellValueAsStringComparator;
import org.eclipse.nebula.widgets.nattable.search.gui.SearchDialog;
import org.eclipse.nebula.widgets.nattable.ui.action.IKeyAction;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.widgets.Shell;

public class SearchAction
implements IKeyAction {
    private SearchDialog dialog;
    private NatTable natTable;
    private IDialogSettings dialogSettings;
    private boolean modal;
    private SearchDialogCreator creator;
    private DisposeListener listener = e -> {
        if (this.dialog != null) {
            if (this.dialog.isModal()) {
                this.dialog.close();
                this.dialog = null;
            } else {
                this.dialog.setInput(null, null);
            }
        }
    };

    public SearchAction() {
        this(null, null, true, (n, c, s) -> new SearchDialog(n, c, s));
    }

    public SearchAction(SearchDialogCreator creator) {
        this(null, null, true, creator);
    }

    public SearchAction(NatTable natTable, IDialogSettings dialogSettings) {
        this(natTable, dialogSettings, false, (n, c, s) -> new SearchDialog(n, c, s));
        if (natTable == null) {
            throw new IllegalArgumentException();
        }
    }

    public SearchAction(NatTable natTable, IDialogSettings dialogSettings, SearchDialogCreator creator) {
        this(natTable, dialogSettings, false, (n, c, s) -> new SearchDialog(n, c, s));
        if (natTable == null) {
            throw new IllegalArgumentException();
        }
    }

    private SearchAction(NatTable natTable, IDialogSettings dialogSettings, boolean modal, SearchDialogCreator creator) {
        this.natTable = natTable;
        this.dialogSettings = dialogSettings;
        this.modal = modal;
        this.creator = creator;
        if (natTable != null) {
            natTable.addFocusListener((FocusListener)new FocusAdapter(){

                public void focusGained(FocusEvent e) {
                    SearchAction.this.setActiveContext();
                }
            });
            natTable.addDisposeListener(this.listener);
        }
    }

    protected void setActiveContext() {
        if (this.dialog != null && this.dialog.getNatTable() != null && !this.isEquivalentToActiveContext()) {
            this.dialog.close();
            this.dialog = null;
        }
        if (this.dialog != null) {
            this.dialog.setInput(this.natTable, this.dialogSettings);
        }
    }

    private boolean isEquivalentToActiveContext() {
        if (this.modal) {
            return this.natTable == this.dialog.getNatTable() && this.dialogSettings == this.dialog.getOriginalDialogSettings() && this.modal == this.dialog.isModal();
        }
        if (this.dialog.isModal()) {
            return false;
        }
        return !this.natTable.isDisposed() && this.dialog.getNatTable() != null && !this.dialog.getNatTable().isDisposed() && this.natTable.getShell().equals(this.dialog.getNatTable().getShell()) && (this.dialogSettings == null && this.dialog.getOriginalDialogSettings() == null || this.dialogSettings != null && this.dialogSettings.equals(this.dialog.getOriginalDialogSettings()));
    }

    @Override
    public void run(NatTable natTable, KeyEvent event) {
        if (this.natTable != natTable) {
            if (this.natTable != null) {
                this.natTable.removeDisposeListener(this.listener);
            }
            this.natTable = natTable;
            this.natTable.addDisposeListener(this.listener);
        }
        this.setActiveContext();
        if (this.dialog == null) {
            this.dialog = this.creator.create(this.natTable.getShell(), new CellValueAsStringComparator(), this.modal ? 0 : 65536);
            this.dialog.setInput(this.natTable, this.dialogSettings);
        }
        this.dialog.open();
    }

    public static interface SearchDialogCreator {
        public SearchDialog create(Shell var1, Comparator<?> var2, int var3);
    }
}

