/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.domain.services.internal.helpers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.papyrus.uml.domain.services.EMFUtils;
import org.eclipse.papyrus.uml.domain.services.UMLHelper;
import org.eclipse.uml2.uml.CombinedFragment;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Interaction;
import org.eclipse.uml2.uml.InteractionOperand;
import org.eclipse.uml2.uml.UMLPackage;

public class UMLService {
    public List<EObject> getAllReachable(EObject eObject, String type) {
        return this.getAllReachable(eObject, type, true);
    }

    public List<EObject> getAllReachable(EObject eObject, String type, boolean withSubType) {
        ResourceSet rs = eObject.eResource().getResourceSet();
        EClass eClass = UMLHelper.toEClass(type);
        if (eClass != null) {
            Predicate<Notifier> predicate = withSubType ? e -> e instanceof EObject && eClass.isInstance(e) : e -> e instanceof EObject && eClass == ((EObject)e).eClass();
            return UMLService.getUmlResources((EList<Resource>)rs.getResources()).flatMap(r -> EMFUtils.eAllContentSteamWithSelf(r)).filter(predicate).map(EObject.class::cast).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public static Stream<Resource> getUmlResources(EList<Resource> resources) {
        return resources.stream().filter(r -> !r.getContents().isEmpty() && r.getContents().get(0) instanceof Element);
    }

    public static boolean isInteractionContainer(EObject object) {
        return object instanceof InteractionOperand || object instanceof CombinedFragment || object instanceof Interaction;
    }

    public static Collection<EObject> getReferencers(EObject eObject, EReference[] features, ECrossReferenceAdapter crossReferenceAdapter) {
        ArrayList<EObject> referencers;
        block6: {
            int count;
            Collection settings;
            referencers = new ArrayList<EObject>();
            if (crossReferenceAdapter == null || (settings = crossReferenceAdapter.getInverseReferences(eObject)).isEmpty()) break block6;
            if (features != null && (count = features.length) != 0) {
                block0: for (EStructuralFeature.Setting setting : settings) {
                    EStructuralFeature feature = setting.getEStructuralFeature();
                    int i = 0;
                    while (i < count) {
                        if (feature == features[i]) {
                            referencers.add(setting.getEObject());
                            continue block0;
                        }
                        ++i;
                    }
                }
            } else {
                Iterator it = settings.iterator();
                while (it.hasNext()) {
                    referencers.add(((EStructuralFeature.Setting)it.next()).getEObject());
                }
            }
        }
        return referencers;
    }

    public static boolean isOnlyUsage(EObject usedObject, EObject knownReferencer, ECrossReferenceAdapter crossReferenceAdapter) {
        EObject container = usedObject.eContainer();
        for (EStructuralFeature.Setting setting : crossReferenceAdapter.getInverseReferences(usedObject, false)) {
            EObject eObj = setting.getEObject();
            if (eObj.eClass().getEPackage() != UMLPackage.eINSTANCE || setting.getEStructuralFeature().isDerived() || eObj == knownReferencer || eObj == container) continue;
            return false;
        }
        return true;
    }
}

