/*******************************************************************************
 * Copyright (c) 2006 - 2012 CEA LIST.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *     CEA LIST - initial API and implementation
 *******************************************************************************/

package org.eclipse.papyrus.designer.languages.c.codegen.preferences;

import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.papyrus.designer.languages.c.codegen.Activator;


public class CCodeGenPreferenceInitializer extends AbstractPreferenceInitializer {

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer#initializeDefaultPreferences()
	 */
	public void initializeDefaultPreferences() {
		IPreferenceStore store = Activator.getDefault().getPreferenceStore();
		store.setDefault(CCodeGenConstants.P_HEADER_SUFFIX, "h"); //$NON-NLS-1$
		store.setDefault(CCodeGenConstants.P_IMPLEM_SUFFIX, "c"); //$NON-NLS-1$
		store.setDefault(CCodeGenConstants.P_OUT_INOUT_OP, "*"); //$NON-NLS-1$
		store.setDefault(CCodeGenConstants.P_PROJECT_PREFIX, "org.eclipse.papyrus.cgen."); //$NON-NLS-1$
		store.setDefault(CCodeGenConstants.P_FORMAT_CODE, true);

		// Default value for P_COMMENT_HEADER
		String NL = System.getProperties().getProperty("line.separator"); //$NON-NLS-1$
		String defaultValue =
				"// --------------------------------------------------------" + NL + //$NON-NLS-1$
				"// Code generated by Papyrus C" + NL + //$NON-NLS-1$
				"// --------------------------------------------------------" + NL + //$NON-NLS-1$
				NL;
		store.setDefault(CCodeGenConstants.P_COMMENT_HEADER, defaultValue);
	}
}
