/**
 * Copyright (c) 2015 CEA LIST.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * Contributors:
 *     CEA LIST - initial API and implementation
 */
package org.eclipse.papyrus.designer.languages.c.codegen.header;

import org.eclipse.papyrus.designer.languages.c.codegen.lib.CommonScript;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.xtend2.lib.StringConcatenation;

@SuppressWarnings("all")
public class CommonHeaderScript {
  public static CharSequence genHeadingHeader(final NamedElement namedElement) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("#ifndef ");
    String _upperCase = CommonScript.genName(namedElement).toString().toUpperCase();
    _builder.append(_upperCase);
    _builder.append("_H_");
    _builder.newLineIfNotEmpty();
    _builder.append("#define ");
    String _upperCase_1 = CommonScript.genName(namedElement).toString().toUpperCase();
    _builder.append(_upperCase_1);
    _builder.append("_H_");
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  public static CharSequence genEndHeader(final NamedElement namedElement) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("#endif /*");
    String _upperCase = CommonScript.genName(namedElement).toString().toUpperCase();
    _builder.append(_upperCase);
    _builder.append("_H_*/");
    _builder.newLineIfNotEmpty();
    return _builder;
  }
}
