/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.transaction.multithread.tests;

import java.io.File;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.commands.operations.DefaultOperationHistory;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.internal.EMFTransactionPlugin;
import org.eclipse.emf.workspace.WorkspaceEditingDomainFactory;

public class EMFTransansactionTest
extends TestCase {
    private TransactionalEditingDomain editingDomain;
    private Thread.UncaughtExceptionHandler exceptionHandler;
    private ILogListener listener;
    private AtomicBoolean errorDetected = new AtomicBoolean();

    public static Test suite() {
        return new TestSuite(EMFTransansactionTest.class, "Concurrent Transaction Tests");
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.exceptionHandler = new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                EMFTransansactionTest.this.errorDetected.set(true);
            }
        };
    }

    public void testSynchronizationBug() throws Exception {
        ResourceSetImpl rset = new ResourceSetImpl();
        this.editingDomain = this.createEditingDomain((ResourceSet)rset);
        final EPackage ePackage = EcoreFactory.eINSTANCE.createEPackage();
        EClass eClass = EcoreFactory.eINSTANCE.createEClass();
        ePackage.getEClassifiers().add((Object)eClass);
        final EReference eReference = EcoreFactory.eINSTANCE.createEReference();
        eClass.getEReferences().add((Object)eReference);
        URI fileUri = URI.createFileURI((String)new File("test.ecore").getAbsolutePath());
        final Resource rs = rset.createResource(fileUri);
        this.editingDomain.getCommandStack().execute((Command)new RecordingCommand(this.editingDomain){

            protected void doExecute() {
                rs.getContents().add((Object)ePackage);
            }
        });
        final EPackage ePackage2 = EcoreFactory.eINSTANCE.createEPackage();
        EClass eClass2 = EcoreFactory.eINSTANCE.createEClass();
        ePackage2.getEClassifiers().add((Object)eClass2);
        final EReference eReference2 = EcoreFactory.eINSTANCE.createEReference();
        eClass2.getEReferences().add((Object)eReference2);
        URI file2Uri = URI.createFileURI((String)new File("test2.ecore").getAbsolutePath());
        final Resource rs2 = rset.createResource(file2Uri);
        this.editingDomain.getCommandStack().execute((Command)new RecordingCommand(this.editingDomain){

            protected void doExecute() {
                rs2.getContents().add((Object)ePackage2);
            }
        });
        this.editingDomain.getCommandStack().execute((Command)new RecordingCommand(this.editingDomain){

            protected void doExecute() {
                eReference.setEOpposite(eReference2);
            }
        });
        Thread.setDefaultUncaughtExceptionHandler(this.exceptionHandler);
        this.listener = (status, plugin) -> {
            if (status.getSeverity() == 4) {
                this.errorDetected.set(true);
            }
        };
        EMFTransactionPlugin.getPlugin().getLog().addLogListener(this.listener);
        ArrayList<Thread> threads = new ArrayList<Thread>();
        int i = 0;
        while (i < 100) {
            threads.add(this.launchNotificationInANewThread(eReference, eReference2));
            ++i;
        }
        for (Thread thread : threads) {
            thread.join();
        }
        EMFTransactionPlugin.getPlugin().getLog().removeLogListener(this.listener);
        if (this.errorDetected.get()) {
            EMFTransansactionTest.fail();
        }
    }

    private TransactionalEditingDomain createEditingDomain(ResourceSet rset) {
        DefaultOperationHistory history = new DefaultOperationHistory();
        return WorkspaceEditingDomainFactory.INSTANCE.createEditingDomain(rset, (IOperationHistory)history);
    }

    private Thread launchNotificationInANewThread(EReference ref1, EReference ref2) throws Exception {
        Thread t = new Thread(() -> {
            int i = 0;
            while (i < 200) {
                ref1.eNotify((Notification)new ENotificationImpl((InternalEObject)ref1, 9, 21, null, (Object)ref2));
                ++i;
            }
        });
        t.start();
        return t;
    }
}

