/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.rcp.ui.tests.mergeviewer.item;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterators;
import java.io.IOException;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.EMFCompare;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.rcp.internal.extension.impl.EMFCompareBuilderConfigurator;
import org.eclipse.emf.compare.rcp.ui.internal.mergeviewer.item.impl.MergeViewerItem;
import org.eclipse.emf.compare.rcp.ui.internal.util.MergeViewerUtil;
import org.eclipse.emf.compare.rcp.ui.mergeviewer.IMergeViewer;
import org.eclipse.emf.compare.rcp.ui.tests.mergeviewer.item.data.nodes.pseudoconflict.MergeViewerItemEcorePseudoConflictInputData;
import org.eclipse.emf.compare.scope.DefaultComparisonScope;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.eclipse.emf.compare.utils.EMFComparePredicates;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class MergeViewerItemPseudoConflictTest {
    private static MergeViewerItemEcorePseudoConflictInputData inputData = new MergeViewerItemEcorePseudoConflictInputData();
    private static final ComposedAdapterFactory fAdapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
    private static Comparison comparison;

    @BeforeClass
    public static void beforeClass() throws IOException {
        fAdapterFactory.addAdapterFactory((AdapterFactory)new ReflectiveItemProviderAdapterFactory());
        fAdapterFactory.addAdapterFactory((AdapterFactory)new ResourceItemProviderAdapterFactory());
        Resource leftResource = inputData.getLeft();
        Resource rightResource = inputData.getRight();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)leftResource, (Notifier)rightResource, null);
        EMFCompare.Builder comparisonBuilder = EMFCompare.builder();
        EMFCompareBuilderConfigurator.createDefault().configure(comparisonBuilder);
        comparison = comparisonBuilder.build().compare((IComparisonScope)scope);
    }

    @Test
    public void test3WayRefContainmentOnPseudoAddConflict() throws IOException {
        EList differences = comparison.getDifferences();
        Predicate eClassA = EMFComparePredicates.addedToReference((String)"P.SP", (String)"eClassifiers", (String)"P.SP.A");
        Diff eClassADiff = (Diff)Iterators.find(differences.iterator(), (Predicate)eClassA);
        EObject eClassAValue = (EObject)MergeViewerUtil.getDiffValue((Diff)eClassADiff);
        Match eClassAMatch = comparison.getMatch(eClassAValue);
        MergeViewerItem.Container eClassAMVI = new MergeViewerItem.Container(comparison, eClassADiff, eClassAMatch, IMergeViewer.MergeViewerSide.LEFT, (AdapterFactory)fAdapterFactory);
        Assert.assertEquals((Object)eClassAMVI.getLeft(), (Object)eClassAValue);
        Assert.assertNull((Object)eClassAMVI.getRight());
        Assert.assertFalse((boolean)eClassAMVI.isInsertionPoint());
        Assert.assertNotNull((Object)eClassAMVI.getParent());
    }
}

