/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.tests.unit;

import java.util.ArrayList;
import org.eclipse.emf.compare.CompareFactory;
import org.eclipse.emf.compare.ComparePackage;
import org.eclipse.emf.compare.Conflict;
import org.eclipse.emf.compare.ConflictKind;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.tests.unit.AbstractCompareTest;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.junit.Assert;
import org.junit.Test;

public class ConflictTest
extends AbstractCompareTest {
    @Test
    public void testDifferences() {
        EReference feature = ComparePackage.eINSTANCE.getConflict_Differences();
        Conflict conflict = CompareFactory.eINSTANCE.createConflict();
        conflict.eAdapters().add((Object)new AbstractCompareTest.MockEAdapter(this));
        Diff differencesValue = CompareFactory.eINSTANCE.createDiff();
        ArrayList<Diff> listDifferences = new ArrayList<Diff>(1);
        listDifferences.add(differencesValue);
        Assert.assertFalse((boolean)conflict.eIsSet((EStructuralFeature)feature));
        Assert.assertTrue((boolean)conflict.getDifferences().isEmpty());
        conflict.getDifferences().add((Object)differencesValue);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertTrue((boolean)conflict.getDifferences().contains((Object)differencesValue));
        Assert.assertSame((Object)conflict.getDifferences(), (Object)conflict.eGet((EStructuralFeature)feature));
        Assert.assertSame((Object)conflict.getDifferences(), (Object)conflict.eGet((EStructuralFeature)feature, false));
        Assert.assertTrue((boolean)conflict.eIsSet((EStructuralFeature)feature));
        Assert.assertTrue((differencesValue.getConflict() == conflict ? 1 : 0) != 0);
        conflict.eUnset((EStructuralFeature)feature);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertTrue((boolean)conflict.getDifferences().isEmpty());
        Assert.assertSame((Object)conflict.getDifferences(), (Object)conflict.eGet((EStructuralFeature)feature));
        Assert.assertSame((Object)conflict.getDifferences(), (Object)conflict.eGet((EStructuralFeature)feature, false));
        Assert.assertFalse((boolean)conflict.eIsSet((EStructuralFeature)feature));
        Assert.assertFalse((differencesValue.getConflict() == conflict ? 1 : 0) != 0);
        conflict.eSet((EStructuralFeature)feature, listDifferences);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertTrue((boolean)conflict.getDifferences().contains((Object)differencesValue));
        Assert.assertSame((Object)conflict.getDifferences(), (Object)conflict.eGet((EStructuralFeature)feature));
        Assert.assertSame((Object)conflict.getDifferences(), (Object)conflict.eGet((EStructuralFeature)feature, false));
        Assert.assertTrue((boolean)conflict.eIsSet((EStructuralFeature)feature));
        Assert.assertTrue((differencesValue.getConflict() == conflict ? 1 : 0) != 0);
    }

    @Test
    public void testKind() {
        EAttribute feature = ComparePackage.eINSTANCE.getConflict_Kind();
        Conflict conflict = CompareFactory.eINSTANCE.createConflict();
        conflict.eAdapters().add((Object)new AbstractCompareTest.MockEAdapter(this));
        ConflictKind kindValue = (ConflictKind)feature.getDefaultValue();
        for (ConflictKind aConflictKind : ConflictKind.VALUES) {
            if (kindValue.getValue() == aConflictKind.getValue()) continue;
            kindValue = aConflictKind;
            break;
        }
        Assert.assertFalse((boolean)conflict.eIsSet((EStructuralFeature)feature));
        Assert.assertEquals((Object)feature.getDefaultValue(), (Object)conflict.getKind());
        conflict.setKind(kindValue);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertEquals((Object)kindValue, (Object)conflict.getKind());
        Assert.assertEquals((Object)conflict.getKind(), (Object)conflict.eGet((EStructuralFeature)feature));
        Assert.assertTrue((boolean)conflict.eIsSet((EStructuralFeature)feature));
        conflict.eUnset((EStructuralFeature)feature);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertEquals((Object)feature.getDefaultValue(), (Object)conflict.getKind());
        Assert.assertEquals((Object)conflict.getKind(), (Object)conflict.eGet((EStructuralFeature)feature));
        Assert.assertFalse((boolean)conflict.eIsSet((EStructuralFeature)feature));
        conflict.eSet((EStructuralFeature)feature, (Object)kindValue);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertEquals((Object)kindValue, (Object)conflict.getKind());
        Assert.assertEquals((Object)conflict.getKind(), (Object)conflict.eGet((EStructuralFeature)feature));
        Assert.assertTrue((boolean)conflict.eIsSet((EStructuralFeature)feature));
        conflict.setKind(null);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertEquals((Object)feature.getDefaultValue(), (Object)conflict.getKind());
        Assert.assertEquals((Object)conflict.getKind(), (Object)conflict.eGet((EStructuralFeature)feature));
        Assert.assertFalse((boolean)conflict.eIsSet((EStructuralFeature)feature));
    }
}

