/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml;

import org.eclipse.emf.common.util.BasicDiagnostic;

public class QvtMessage
extends BasicDiagnostic {
    public static final int SEVERITY_ERROR = 4;
    public static final int SEVERITY_WARNING = 2;
    private final int myLineNum;
    private final TextPositionsImpl myPos;

    public QvtMessage(String message, int severity, int offset, int length, int lineNum) {
        super(severity, "org.eclipse.m2m.qvt.oml", 0, message, new Object[0]);
        this.myPos = new TextPositionsImpl(offset, length);
        this.myLineNum = lineNum;
    }

    public QvtMessage(String message, int offset, int length) {
        this(message, 4, offset, length, -1);
    }

    public QvtMessage(String message) {
        this(message, 0, 0);
    }

    public int getOffset() {
        return this.myPos.getOffset();
    }

    public int getLength() {
        return this.myPos.getLength();
    }

    public int getLineNum() {
        return this.myLineNum;
    }

    public String toString() {
        return String.valueOf(this.getLineNum() > 0 ? "Line " + this.getLineNum() + ':' : this.myPos.toString()) + " " + this.getMessage();
    }

    public boolean equals(Object o) {
        if (!(o instanceof QvtMessage)) {
            return false;
        }
        QvtMessage other = (QvtMessage)((Object)o);
        if (this.getSeverity() != other.getSeverity()) {
            return false;
        }
        if (this.getMessage() == null ? other.getMessage() != null : !this.getMessage().equals(other.getMessage())) {
            return false;
        }
        return !(this.myPos == null ? other.myPos != null : !this.myPos.equals(other.myPos));
    }

    public int hashCode() {
        int hash = 17;
        hash = hash * 37 + this.getSeverity();
        if (this.getMessage() != null) {
            hash = hash * 37 + this.getMessage().hashCode();
        }
        if (this.myPos != null) {
            hash = hash * 37 + this.myPos.hashCode();
        }
        return hash;
    }

    private class TextPositionsImpl {
        private final int myOffset;
        private final int myLength;

        public TextPositionsImpl(int offset, int length) {
            this.myOffset = offset;
            this.myLength = length;
        }

        public int getOffset() {
            return this.myOffset;
        }

        public int getLength() {
            return this.myLength;
        }

        public String toString() {
            return "[" + this.myOffset + ":" + (this.myOffset + this.myLength) + "]";
        }

        public boolean equals(Object o) {
            if (!(o instanceof TextPositionsImpl)) {
                return false;
            }
            TextPositionsImpl other = (TextPositionsImpl)o;
            return this.myOffset == other.myOffset && this.myLength == other.myLength;
        }

        public int hashCode() {
            int hash = 17;
            hash = hash * 37 + this.myOffset;
            hash = hash * 37 + this.myLength;
            return hash;
        }
    }
}

