/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.editor.internal;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.imp.core.ErrorHandler;
import org.eclipse.imp.language.Language;
import org.eclipse.imp.language.ServiceFactory;
import org.eclipse.imp.parser.IModelListener;
import org.eclipse.imp.parser.IParseController;
import org.eclipse.imp.services.IContentProposer;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;

public class CompletionProcessor
implements IContentAssistProcessor,
IModelListener {
    private final IContextInformation[] NO_CONTEXTS = new IContextInformation[0];
    private ICompletionProposal[] NO_COMPLETIONS = new ICompletionProposal[0];
    private final Language fLanguage;
    private IParseController fParseController;
    private IContentProposer fContentProposer;

    public CompletionProcessor(Language language) {
        this.fLanguage = language;
        this.fContentProposer = ServiceFactory.getInstance().getContentProposer(this.fLanguage);
    }

    public IModelListener.AnalysisRequired getAnalysisRequired() {
        return IModelListener.AnalysisRequired.LEXICAL_ANALYSIS;
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        try {
            if (this.fParseController != null && this.fContentProposer != null) {
                return this.fContentProposer.getContentProposals(this.fParseController, offset, viewer);
            }
        }
        catch (Throwable e) {
            ErrorHandler.reportError("Exception caught from language-specific content proposer implementation", e);
        }
        return this.NO_COMPLETIONS;
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        return this.NO_CONTEXTS;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return null;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    public String getErrorMessage() {
        return null;
    }

    public void update(IParseController parseController, IProgressMonitor monitor) {
        this.fParseController = parseController;
    }

    public void dispose() {
        this.fParseController = null;
        this.fContentProposer = null;
    }

    public String toString() {
        return "Completion processor for " + this.fLanguage.getName() + " on " + this.fParseController.getPath().toPortableString();
    }
}

