/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvtr2qvts;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.Variable;
import org.eclipse.ocl.pivot.VariableDeclaration;
import org.eclipse.qvtd.compiler.internal.qvtr2qvts.InvocationAnalysis;
import org.eclipse.qvtd.compiler.internal.qvtr2qvts.QVTrelationScheduleManager;
import org.eclipse.qvtd.compiler.internal.qvtr2qvts.RelationAnalysis;
import org.eclipse.qvtd.compiler.internal.qvtr2qvts.trace.Invocation2TraceProperty;
import org.eclipse.qvtd.compiler.internal.qvtr2qvts.trace.Relation2MiddleType;
import org.eclipse.qvtd.compiler.internal.qvtr2qvts.trace.Relation2TraceClass;
import org.eclipse.qvtd.compiler.internal.qvtr2qvts.trace.Relation2TraceGroup;
import org.eclipse.qvtd.pivot.qvtbase.Rule;
import org.eclipse.qvtd.pivot.qvtbase.TypedModel;
import org.eclipse.qvtd.pivot.qvtrelation.Relation;
import org.eclipse.qvtd.pivot.qvtrelation.utilities.QVTrelationUtil;
import org.eclipse.qvtd.pivot.qvtschedule.ClassDatum;
import org.eclipse.qvtd.pivot.qvtschedule.NavigableEdge;
import org.eclipse.qvtd.pivot.qvtschedule.Node;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.DomainUsage;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.QVTscheduleUtil;

public abstract class AbstractInvocationAnalysis
implements InvocationAnalysis {
    protected final @NonNull RelationAnalysis invokingRelationAnalysis;
    protected final @NonNull RelationAnalysis invokedRelationAnalysis;
    protected final @NonNull QVTrelationScheduleManager scheduleManager;
    protected final @NonNull Map<@NonNull VariableDeclaration, @NonNull Node> rootVariable2argumentNode = new HashMap<VariableDeclaration, Node>();
    private @Nullable Node invokedNode = null;

    public AbstractInvocationAnalysis(@NonNull RelationAnalysis invokingRelationAnalysis, @NonNull RelationAnalysis invokedRelationAnalysis) {
        this.invokingRelationAnalysis = invokingRelationAnalysis;
        this.invokedRelationAnalysis = invokedRelationAnalysis;
        this.scheduleManager = invokedRelationAnalysis.getScheduleManager();
    }

    @Override
    public void addBinding(@NonNull VariableDeclaration rootVariable, @NonNull Node argumentNode) {
        Node oldNode = this.rootVariable2argumentNode.put(rootVariable, argumentNode);
        assert (oldNode == null);
    }

    protected void createGlobalSuccessNodeAndEdge(@NonNull Node invokedNode) {
    }

    protected abstract @NonNull NavigableEdge createInputEdge(@NonNull Node var1, @NonNull Property var2, @NonNull Node var3);

    protected void createInvocationEdges(@NonNull Node invokedNode) {
        Relation2MiddleType baseInvokedRule2MiddleType = this.getBaseInvokedRule2MiddleType();
        Relation baseInvokedRelation = this.getBaseInvokedRelation();
        for (VariableDeclaration rootVariable : this.rootVariable2argumentNode.keySet()) {
            Node argumentNode = this.rootVariable2argumentNode.get(rootVariable);
            assert (argumentNode != null);
            Variable overriddenRootVariable = QVTrelationUtil.getOverriddenVariable((Relation)baseInvokedRelation, (VariableDeclaration)rootVariable);
            Property invocationProperty = baseInvokedRule2MiddleType.getTraceProperty((VariableDeclaration)overriddenRootVariable);
            ClassDatum classDatum = QVTscheduleUtil.getClassDatum((Node)argumentNode);
            DomainUsage domainUsage = this.scheduleManager.getDomainUsage((Element)classDatum);
            if (this.scheduleManager.isOutput(domainUsage)) {
                this.createOutputEdge(invokedNode, invocationProperty, argumentNode);
                continue;
            }
            this.createInputEdge(invokedNode, invocationProperty, argumentNode);
        }
    }

    protected abstract @NonNull Node createInvocationNode(@NonNull Node var1);

    protected void createInvokingTraceEdge(@NonNull Node invokedNode, @NonNull Node invokingTraceNode) {
        Relation2TraceGroup invokingRule2TraceGroup = this.invokingRelationAnalysis.getRule2TraceGroup();
        Relation2TraceClass invokingRule2TraceClass = invokingRule2TraceGroup.getRule2TraceClass();
        Invocation2TraceProperty invokingInvocation2TraceProperty = invokingRule2TraceClass.getInvocation2TraceProperty(this);
        Property invocationTraceProperty = invokingInvocation2TraceProperty.getTraceProperty();
        boolean isPartial = this.scheduleManager.computeIsPartial(invokedNode, invocationTraceProperty);
        this.invokingRelationAnalysis.createRealizedNavigationEdge(invokingTraceNode, invocationTraceProperty, invokedNode, isPartial);
    }

    protected abstract @NonNull NavigableEdge createOutputEdge(@NonNull Node var1, @NonNull Property var2, @NonNull Node var3);

    @Override
    public @NonNull Iterable<@NonNull Node> getArgumentNodes() {
        return this.rootVariable2argumentNode.values();
    }

    protected @NonNull Relation getBaseInvokedRelation() {
        return QVTrelationUtil.getBaseRelation((Relation)this.invokedRelationAnalysis.getRule());
    }

    protected @NonNull Relation2MiddleType getBaseInvokedRule2MiddleType() {
        Relation invokedRelation = this.invokedRelationAnalysis.getRule();
        Relation baseInvokedRelation = this.getBaseInvokedRelation();
        RelationAnalysis baseInvokedRelationAnalysis = this.scheduleManager.getRuleAnalysis((Rule)baseInvokedRelation);
        Relation2TraceGroup baseInvokedrelation2traceGroup = baseInvokedRelationAnalysis.getRule2TraceGroup();
        Relation2MiddleType baseInvokedRule2MiddleType = QVTrelationUtil.hasOverrides((Relation)invokedRelation) ? baseInvokedrelation2traceGroup.getRule2DispatchClass() : (this.isTop() ? baseInvokedrelation2traceGroup.getRule2TraceInterface() : baseInvokedrelation2traceGroup.getRule2InvocationInterface());
        return baseInvokedRule2MiddleType;
    }

    protected @NonNull ClassDatum getInvokedClassDatum() {
        TypedModel traceTypedModel = this.scheduleManager.getTraceTypedModel();
        Relation2MiddleType invokedRelation2InvocationInterface = this.getInvokedRelation2InvocationInterface();
        Class invokedInvocationInterface = invokedRelation2InvocationInterface.getMiddleClass();
        return this.scheduleManager.getClassDatum(traceTypedModel, invokedInvocationInterface);
    }

    @Override
    public @NonNull RelationAnalysis getInvokedRelationAnalysis() {
        return this.invokedRelationAnalysis;
    }

    protected @NonNull Relation2MiddleType getInvokedRelation2InvocationInterface() {
        Relation2TraceGroup invokedBaserelation2traceGroup = this.invokedRelationAnalysis.getRule2TraceGroup().getBaseRelation2TraceGroup();
        Relation2MiddleType invokedRelation2InvocationInterface = invokedBaserelation2traceGroup.getRule2InvocationInterface();
        return invokedRelation2InvocationInterface;
    }

    @Override
    public @NonNull RelationAnalysis getInvokingRelationAnalysis() {
        return this.invokingRelationAnalysis;
    }

    protected boolean isMatched() {
        for (VariableDeclaration rootVariable : this.rootVariable2argumentNode.keySet()) {
            Node argumentNode = this.rootVariable2argumentNode.get(rootVariable);
            assert (argumentNode != null);
            if (argumentNode.isMatched()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isRealized() {
        assert (this.invokedNode != null);
        return this.invokedNode.isRealized();
    }

    @Override
    public boolean needsInvocationTraceProperty() {
        return true;
    }

    @Override
    public void setStrict(boolean isStrict) {
        assert (this.invokedNode != null);
        this.invokedNode.setStrict(isStrict);
    }

    @Override
    public void synthesizeInvocationNodes(@NonNull Node invokingTraceNode) {
        assert (this.invokedNode == null);
        Node invokedNode2 = this.invokedNode = this.createInvocationNode(invokingTraceNode);
        this.createInvokingTraceEdge(invokedNode2, invokingTraceNode);
        this.createGlobalSuccessNodeAndEdge(invokedNode2);
        this.createInvocationEdges(invokedNode2);
    }
}

