/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvts2qvti;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.CollectionType;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.Variable;
import org.eclipse.ocl.pivot.VariableExp;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.Node;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.NodeConnection;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.Region;
import org.eclipse.qvtd.compiler.internal.qvts2qvti.AbstractRegion2Mapping;
import org.eclipse.qvtd.compiler.internal.qvts2qvti.QVTs2QVTiVisitor;
import org.eclipse.qvtd.pivot.qvtimperative.Mapping;
import org.eclipse.qvtd.pivot.qvtimperative.MappingCall;
import org.eclipse.qvtd.pivot.qvtimperative.MappingCallBinding;
import org.eclipse.qvtd.pivot.qvtimperative.MappingStatement;
import org.eclipse.qvtd.pivot.qvtimperative.utilities.QVTimperativeUtil;

public abstract class AbstractScheduledRegion2Mapping
extends AbstractRegion2Mapping {
    protected AbstractScheduledRegion2Mapping(@NonNull QVTs2QVTiVisitor visitor, @NonNull Region region) {
        super(visitor, region);
        this.connection2variable = new HashMap();
    }

    protected @NonNull MappingStatement createCall(@Nullable MappingStatement mappingStatement, @NonNull Region calledRegion, @Nullable Map<@NonNull Variable, @NonNull OCLExpression> guardVariable2expression) {
        AbstractRegion2Mapping calledRegion2Mapping = this.visitor.getRegion2Mapping(calledRegion);
        Mapping calledMapping = calledRegion2Mapping.getMapping();
        HashMap<@NonNull Variable, @NonNull OCLExpression> loopVariables = new HashMap<Variable, OCLExpression>();
        ArrayList<@NonNull MappingCallBinding> mappingCallBindings = new ArrayList<MappingCallBinding>();
        for (Node calledGuardNode : calledRegion2Mapping.getGuardNodes()) {
            Variable guardVariable = calledRegion2Mapping.getGuardVariable(calledGuardNode);
            NodeConnection callingConnection = calledGuardNode.getIncomingPassedConnection();
            if (callingConnection != null) {
                OCLExpression connectionExpression = null;
                if (guardVariable2expression != null) {
                    connectionExpression = guardVariable2expression.get(guardVariable);
                }
                if (connectionExpression == null) {
                    Variable connectionVariable = (Variable)this.connection2variable.get(callingConnection);
                    if (connectionVariable != null) {
                        connectionExpression = PivotUtil.createVariableExp((Variable)connectionVariable);
                    } else {
                        Node callingNode = callingConnection.getSource(this.region);
                        connectionExpression = this.createSelectByKind(callingNode);
                    }
                }
                MappingCallBinding mappingCallBinding = this.createMappingCallBinding(connectionExpression, calledGuardNode, loopVariables);
                this.setLegacyIsPolled(calledMapping, mappingCallBinding);
                mappingCallBindings.add(mappingCallBinding);
            }
            for (Node callingNode : calledGuardNode.getUsedBindingSources()) {
                if (callingNode.getRegion() != this.region) continue;
                MappingCallBinding mappingCallBinding = this.createMappingCallBinding(this.createSelectByKind(callingNode), calledGuardNode, loopVariables);
                this.setLegacyIsPolled(calledMapping, mappingCallBinding);
                mappingCallBindings.add(mappingCallBinding);
            }
        }
        for (NodeConnection intermediateConnection : calledRegion.getIntermediateConnections()) {
            Variable calledConnectionVariable = calledRegion2Mapping.getConnectionVariable(intermediateConnection);
            OCLExpression connectionExpression = null;
            if (guardVariable2expression != null) {
                connectionExpression = guardVariable2expression.get(calledConnectionVariable);
            }
            if (connectionExpression == null) {
                Variable callingConnectionVariable = (Variable)this.connection2variable.get(intermediateConnection);
                assert (callingConnectionVariable != null);
                VariableExp sourceExpression = PivotUtil.createVariableExp((Variable)callingConnectionVariable);
                Type calledType = calledConnectionVariable.getType();
                Type callingType = callingConnectionVariable.getType();
                assert (calledType != null);
                assert (callingType != null);
                if (this.getCollectionDepth(calledType) < this.getCollectionDepth(callingType)) {
                    Variable loopVariable = PivotUtil.createVariable((String)("loop" + loopVariables.size()), (Type)calledType, (boolean)true, (OCLExpression)sourceExpression);
                    loopVariables.put(loopVariable, (OCLExpression)sourceExpression);
                    sourceExpression = PivotUtil.createVariableExp((Variable)loopVariable);
                }
                connectionExpression = sourceExpression;
            }
            mappingCallBindings.add(QVTimperativeUtil.createMappingCallBinding((Variable)calledConnectionVariable, (OCLExpression)connectionExpression));
        }
        Collections.sort(mappingCallBindings, QVTimperativeUtil.MappingCallBindingComparator.INSTANCE);
        MappingCall mappingCallStatement = calledRegion2Mapping.createMappingCall(mappingCallBindings);
        for (Map.Entry loopEntry : loopVariables.entrySet()) {
            @NonNull Variable loopVariable = (Variable)loopEntry.getKey();
            @NonNull OCLExpression loopSource = (OCLExpression)loopEntry.getValue();
            mappingCallStatement = QVTimperativeUtil.createMappingLoop((OCLExpression)loopSource, (Variable)loopVariable, (MappingStatement)mappingCallStatement);
        }
        mappingStatement = QVTimperativeUtil.addMappingStatement((MappingStatement)mappingStatement, (MappingStatement)mappingCallStatement);
        return mappingStatement;
    }

    private @NonNull MappingCallBinding createMappingCallBinding(@NonNull OCLExpression sourceExpression, @NonNull Node targetNode, @NonNull Map<@NonNull Variable, @NonNull OCLExpression> loopVariables) {
        Type type = sourceExpression.getType();
        if (type instanceof CollectionType) {
            Type elementType = ((CollectionType)type).getElementType();
            assert (elementType != null);
            Variable loopVariable = PivotUtil.createVariable((String)("loop" + loopVariables.size()), (Type)elementType, (boolean)true, (OCLExpression)sourceExpression);
            loopVariables.put(loopVariable, sourceExpression);
            sourceExpression = PivotUtil.createVariableExp((Variable)loopVariable);
        }
        AbstractRegion2Mapping calledRegion2Mapping = this.visitor.getRegion2Mapping(targetNode.getRegion());
        Variable guardVariable = calledRegion2Mapping.getGuardVariable(targetNode);
        return QVTimperativeUtil.createMappingCallBinding((Variable)guardVariable, (OCLExpression)sourceExpression);
    }

    protected abstract @NonNull OCLExpression createSelectByKind(@NonNull Node var1);
}

