/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.wizards;

import org.eclipse.linuxtools.docker.core.EnumDockerConnectionSettings;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.docker.core.IDockerConnectionSettings;
import org.eclipse.linuxtools.internal.docker.core.TCPConnectionSettings;
import org.eclipse.linuxtools.internal.docker.core.UnixSocketConnectionSettings;
import org.eclipse.linuxtools.internal.docker.ui.databinding.BaseDatabindingModel;

public class EditDockerConnectionPageModel
extends BaseDatabindingModel {
    public static final String CONNECTION_NAME = "connectionName";
    public static final String UNIX_SOCKET_BINDING_MODE = "unixSocketBindingMode";
    public static final String UNIX_SOCKET_PATH = "unixSocketPath";
    public static final String TCP_CONNECTION_BINDING_MODE = "tcpConnectionBindingMode";
    public static final String TCP_HOST = "tcpHost";
    public static final String TCP_TLS_VERIFY = "tcpTLSVerify";
    public static final String TCP_CERT_PATH = "tcpCertPath";
    private final String initialConnectionName;
    private String connectionName;
    private boolean unixSocketBindingMode = false;
    private String unixSocketPath = null;
    private boolean tcpConnectionBindingMode = false;
    private String tcpHost = null;
    private boolean tcpTLSVerify = false;
    private String tcpCertPath = null;

    public EditDockerConnectionPageModel(IDockerConnection connection) {
        this.initialConnectionName = connection.getName();
        this.connectionName = connection.getName();
        if (connection.getSettings().getType() == IDockerConnectionSettings.BindingType.UNIX_SOCKET_CONNECTION) {
            this.setUnixSocketBindingMode(true);
            this.setUnixSocketPath(((UnixSocketConnectionSettings)connection.getSettings()).getPath());
        } else {
            this.setTcpConnectionBindingMode(true);
            this.setTcpHost(((TCPConnectionSettings)connection.getSettings()).getHost());
            this.setTcpTLSVerify(((TCPConnectionSettings)connection.getSettings()).isTlsVerify());
            this.setTcpCertPath(((TCPConnectionSettings)connection.getSettings()).getPathToCertificates());
        }
    }

    public EnumDockerConnectionSettings getBindingMode() {
        if (this.unixSocketBindingMode) {
            return EnumDockerConnectionSettings.UNIX_SOCKET;
        }
        return EnumDockerConnectionSettings.TCP_CONNECTION;
    }

    public void setBindingMode(EnumDockerConnectionSettings bindingMode) {
        this.setUnixSocketBindingMode(bindingMode == EnumDockerConnectionSettings.UNIX_SOCKET);
        this.setTcpConnectionBindingMode(bindingMode == EnumDockerConnectionSettings.TCP_CONNECTION);
    }

    public String getInitialConnectionName() {
        return this.initialConnectionName;
    }

    public String getConnectionName() {
        return this.connectionName;
    }

    public void setConnectionName(String connectionName) {
        this.connectionName = connectionName;
        this.firePropertyChange(CONNECTION_NAME, this.connectionName, this.connectionName);
    }

    public boolean isUnixSocketBindingMode() {
        return this.unixSocketBindingMode;
    }

    public void setUnixSocketBindingMode(boolean unixSocketBindingMode) {
        this.unixSocketBindingMode = unixSocketBindingMode;
        this.firePropertyChange(UNIX_SOCKET_BINDING_MODE, this.unixSocketBindingMode, this.unixSocketBindingMode);
    }

    public String getUnixSocketPath() {
        return this.unixSocketPath;
    }

    public void setUnixSocketPath(String unixSocketPath) {
        this.unixSocketPath = unixSocketPath;
        this.firePropertyChange(UNIX_SOCKET_PATH, this.unixSocketPath, this.unixSocketPath);
    }

    public boolean isTcpConnectionBindingMode() {
        return this.tcpConnectionBindingMode;
    }

    public void setTcpConnectionBindingMode(boolean tcpBindingMode) {
        this.tcpConnectionBindingMode = tcpBindingMode;
        this.firePropertyChange(TCP_CONNECTION_BINDING_MODE, this.tcpConnectionBindingMode, this.tcpConnectionBindingMode);
    }

    public String getTcpHost() {
        return this.tcpHost;
    }

    public void setTcpHost(String tcpHost) {
        this.tcpHost = tcpHost;
        this.firePropertyChange(TCP_HOST, this.tcpHost, this.tcpHost);
    }

    public boolean isTcpTLSVerify() {
        return this.tcpTLSVerify;
    }

    public void setTcpTLSVerify(boolean tcpTLSVerify) {
        this.tcpTLSVerify = tcpTLSVerify;
        this.firePropertyChange(TCP_TLS_VERIFY, this.tcpTLSVerify, this.tcpTLSVerify);
    }

    public String getTcpCertPath() {
        return this.tcpCertPath;
    }

    public void setTcpCertPath(String tcpCertPath) {
        this.tcpCertPath = tcpCertPath;
        this.firePropertyChange(TCP_CERT_PATH, this.tcpCertPath, this.tcpCertPath);
    }
}

