/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.extensions.core;

import java.util.Objects;
import org.eclipse.swtchart.extensions.core.MappingsType;

public class MappingsKey {
    private static final String KEY_DELIMITER = "_";
    private MappingsType mappingsType = MappingsType.NONE;
    private String id = "";
    private String key = "";

    public MappingsKey(String key) {
        this.key = key;
        this.parseKey();
    }

    public MappingsKey(MappingsType mappingsType, String id) {
        this.mappingsType = mappingsType;
        this.id = id;
        this.key = MappingsKey.getKey(mappingsType, id);
    }

    public MappingsType getMappingsType() {
        return this.mappingsType;
    }

    public String getId() {
        return this.id;
    }

    public String getKey() {
        return this.key;
    }

    public static String getKey(MappingsType mappingsType, String id) {
        return mappingsType.name() + KEY_DELIMITER + id;
    }

    private void parseKey() {
        MappingsType[] mappingsTypeArray = MappingsType.values();
        int n = mappingsTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            MappingsType mappingsType = mappingsTypeArray[n2];
            if (this.key.startsWith(mappingsType.name())) {
                this.mappingsType = mappingsType;
                this.id = this.key.substring(mappingsType.name().length() + 1, this.key.length());
                break;
            }
            ++n2;
        }
    }

    public int hashCode() {
        return Objects.hash(this.key);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MappingsKey other = (MappingsKey)obj;
        return Objects.equals(this.key, other.key);
    }

    public String toString() {
        return "MappingsKey [key=" + this.key + "]";
    }
}

