/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.extensions.charts;

import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swtchart.Chart;
import org.eclipse.swtchart.IAxis;
import org.eclipse.swtchart.IPlotArea;
import org.eclipse.swtchart.Range;
import org.eclipse.swtchart.extensions.charts.ChartMenuMessages;
import org.eclipse.swtchart.extensions.charts.Messages;
import org.eclipse.swtchart.extensions.charts.SelectionRectangle;
import org.eclipse.swtchart.extensions.properties.AxisPage;
import org.eclipse.swtchart.extensions.properties.AxisTickPage;
import org.eclipse.swtchart.extensions.properties.ChartPage;
import org.eclipse.swtchart.extensions.properties.GridPage;
import org.eclipse.swtchart.extensions.properties.LegendPage;
import org.eclipse.swtchart.extensions.properties.SeriesLabelPage;
import org.eclipse.swtchart.extensions.properties.SeriesPage;

public class InteractiveChart
extends Chart
implements PaintListener {
    private static final String[] EXTENSIONS = new String[]{"*.png", "*.jpeg", "*.jpg"};
    protected SelectionRectangle selection;
    private long clickedTime;
    private String saveAsFilename;

    public InteractiveChart(Composite parent, int style) {
        super(parent, style);
        this.init();
    }

    private void init() {
        this.selection = new SelectionRectangle();
        IPlotArea area = this.getPlotArea();
        if (area instanceof Control) {
            Control plot = (Control)area;
            plot.addListener(11, (Listener)this);
            plot.addListener(5, (Listener)this);
            plot.addListener(3, (Listener)this);
            plot.addListener(4, (Listener)this);
            plot.addListener(37, (Listener)this);
            plot.addListener(1, (Listener)this);
            plot.addPaintListener((PaintListener)this);
            this.createMenuItems(plot);
        }
        this.setData("org.eclipse.e4.ui.css.CssClassName", "InteractiveChart");
    }

    private void createMenuItems(Control plot) {
        Menu menu = new Menu(plot);
        plot.setMenu(menu);
        MenuItem menuItem = new MenuItem(menu, 64);
        menuItem.setText(ChartMenuMessages.ADJUST_AXIS_RANGE_GROUP);
        Menu adjustAxisRangeMenu = new Menu(menuItem);
        menuItem.setMenu(adjustAxisRangeMenu);
        menuItem = new MenuItem(adjustAxisRangeMenu, 8);
        menuItem.setText(ChartMenuMessages.ADJUST_AXIS_RANGE);
        menuItem.addListener(13, (Listener)this);
        menuItem = new MenuItem(adjustAxisRangeMenu, 8);
        menuItem.setText(ChartMenuMessages.ADJUST_X_AXIS_RANGE);
        menuItem.addListener(13, (Listener)this);
        menuItem = new MenuItem(adjustAxisRangeMenu, 8);
        menuItem.setText(ChartMenuMessages.ADJUST_Y_AXIS_RANGE);
        menuItem.addListener(13, (Listener)this);
        menuItem = new MenuItem(menu, 2);
        menuItem = new MenuItem(menu, 64);
        menuItem.setText(ChartMenuMessages.ZOOMIN_GROUP);
        Menu zoomInMenu = new Menu(menuItem);
        menuItem.setMenu(zoomInMenu);
        menuItem = new MenuItem(zoomInMenu, 8);
        menuItem.setText(ChartMenuMessages.ZOOMIN);
        menuItem.addListener(13, (Listener)this);
        menuItem = new MenuItem(zoomInMenu, 8);
        menuItem.setText(ChartMenuMessages.ZOOMIN_X);
        menuItem.addListener(13, (Listener)this);
        menuItem = new MenuItem(zoomInMenu, 8);
        menuItem.setText(ChartMenuMessages.ZOOMIN_Y);
        menuItem.addListener(13, (Listener)this);
        menuItem = new MenuItem(menu, 64);
        menuItem.setText(ChartMenuMessages.ZOOMOUT_GROUP);
        Menu zoomOutMenu = new Menu(menuItem);
        menuItem.setMenu(zoomOutMenu);
        menuItem = new MenuItem(zoomOutMenu, 8);
        menuItem.setText(ChartMenuMessages.ZOOMOUT);
        menuItem.addListener(13, (Listener)this);
        menuItem = new MenuItem(zoomOutMenu, 8);
        menuItem.setText(ChartMenuMessages.ZOOMOUT_X);
        menuItem.addListener(13, (Listener)this);
        menuItem = new MenuItem(zoomOutMenu, 8);
        menuItem.setText(ChartMenuMessages.ZOOMOUT_Y);
        menuItem.addListener(13, (Listener)this);
        menuItem = new MenuItem(menu, 2);
        menuItem = new MenuItem(menu, 8);
        menuItem.setText(ChartMenuMessages.SAVE_AS);
        menuItem.addListener(13, (Listener)this);
        menuItem = new MenuItem(menu, 2);
        menuItem = new MenuItem(menu, 8);
        menuItem.setText(ChartMenuMessages.PROPERTIES);
        menuItem.addListener(13, (Listener)this);
    }

    public void paintControl(PaintEvent e) {
        this.selection.draw(e.gc);
    }

    public void handleEvent(Event event) {
        super.handleEvent(event);
        switch (event.type) {
            case 5: {
                this.handleMouseMoveEvent(event);
                break;
            }
            case 3: {
                this.handleMouseDownEvent(event);
                break;
            }
            case 4: {
                this.handleMouseUpEvent(event);
                break;
            }
            case 37: {
                this.handleMouseWheel(event);
                break;
            }
            case 1: {
                this.handleKeyDownEvent(event);
                break;
            }
            case 13: {
                this.handleSelectionEvent(event);
                break;
            }
        }
    }

    public void setProposedSaveAsFilename(String saveAsFilename) {
        this.saveAsFilename = saveAsFilename;
    }

    private void handleMouseMoveEvent(Event event) {
        if (!this.selection.isDisposed()) {
            this.selection.setEndPoint(event.x, event.y);
            this.redraw();
        }
    }

    private void handleMouseDownEvent(Event event) {
        if (event.button == 1) {
            this.selection.setStartPoint(event.x, event.y);
            this.clickedTime = System.currentTimeMillis();
        }
    }

    private void handleMouseUpEvent(Event event) {
        if (event.button == 1 && System.currentTimeMillis() - this.clickedTime > 100L) {
            IAxis[] iAxisArray = this.getAxisSet().getAxes();
            int n = iAxisArray.length;
            int n2 = 0;
            while (n2 < n) {
                IAxis axis = iAxisArray[n2];
                Point range = null;
                range = this.getOrientation() == 256 && axis.getDirection() == IAxis.Direction.X || this.getOrientation() == 512 && axis.getDirection() == IAxis.Direction.Y ? this.selection.getHorizontalRange() : this.selection.getVerticalRange();
                if (range != null && range.x != range.y) {
                    this.setRange(range, axis);
                }
                ++n2;
            }
        }
        this.selection.dispose();
        this.redraw();
    }

    private void handleMouseWheel(Event event) {
        double coordinate;
        IAxis axis;
        IAxis[] iAxisArray = this.getAxes(256);
        int n = iAxisArray.length;
        int n2 = 0;
        while (n2 < n) {
            axis = iAxisArray[n2];
            coordinate = axis.getDataCoordinate(event.x);
            if (event.count > 0) {
                axis.zoomIn(coordinate);
            } else {
                axis.zoomOut(coordinate);
            }
            ++n2;
        }
        iAxisArray = this.getAxes(512);
        n = iAxisArray.length;
        n2 = 0;
        while (n2 < n) {
            axis = iAxisArray[n2];
            coordinate = axis.getDataCoordinate(event.y);
            if (event.count > 0) {
                axis.zoomIn(coordinate);
            } else {
                axis.zoomOut(coordinate);
            }
            ++n2;
        }
        this.redraw();
    }

    private void handleKeyDownEvent(Event event) {
        if (event.keyCode == 0x1000002) {
            if (event.stateMask == SWT.MOD1) {
                this.getAxisSet().zoomOut();
            } else {
                IAxis[] iAxisArray = this.getAxes(512);
                int n = iAxisArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IAxis axis = iAxisArray[n2];
                    axis.scrollDown();
                    ++n2;
                }
            }
            this.redraw();
        } else if (event.keyCode == 0x1000001) {
            if (event.stateMask == SWT.MOD1) {
                this.getAxisSet().zoomIn();
            } else {
                IAxis[] iAxisArray = this.getAxes(512);
                int n = iAxisArray.length;
                int n3 = 0;
                while (n3 < n) {
                    IAxis axis = iAxisArray[n3];
                    axis.scrollUp();
                    ++n3;
                }
            }
            this.redraw();
        } else if (event.keyCode == 0x1000003) {
            IAxis[] iAxisArray = this.getAxes(256);
            int n = iAxisArray.length;
            int n4 = 0;
            while (n4 < n) {
                IAxis axis = iAxisArray[n4];
                axis.scrollDown();
                ++n4;
            }
            this.redraw();
        } else if (event.keyCode == 0x1000004) {
            IAxis[] iAxisArray = this.getAxes(256);
            int n = iAxisArray.length;
            int n5 = 0;
            while (n5 < n) {
                IAxis axis = iAxisArray[n5];
                axis.scrollUp();
                ++n5;
            }
            this.redraw();
        }
    }

    private IAxis[] getAxes(int orientation) {
        IAxis[] axes = this.getOrientation() == orientation ? this.getAxisSet().getXAxes() : this.getAxisSet().getYAxes();
        return axes;
    }

    private void handleSelectionEvent(Event event) {
        if (!(event.widget instanceof MenuItem)) {
            return;
        }
        MenuItem menuItem = (MenuItem)event.widget;
        if (menuItem.getText().equals(ChartMenuMessages.ADJUST_AXIS_RANGE)) {
            this.getAxisSet().adjustRange();
        } else if (menuItem.getText().equals(ChartMenuMessages.ADJUST_X_AXIS_RANGE)) {
            IAxis[] iAxisArray = this.getAxisSet().getXAxes();
            int n = iAxisArray.length;
            int n2 = 0;
            while (n2 < n) {
                IAxis axis = iAxisArray[n2];
                axis.adjustRange();
                ++n2;
            }
        } else if (menuItem.getText().equals(ChartMenuMessages.ADJUST_Y_AXIS_RANGE)) {
            IAxis[] iAxisArray = this.getAxisSet().getYAxes();
            int n = iAxisArray.length;
            int n3 = 0;
            while (n3 < n) {
                IAxis axis = iAxisArray[n3];
                axis.adjustRange();
                ++n3;
            }
        } else if (menuItem.getText().equals(ChartMenuMessages.ZOOMIN)) {
            this.getAxisSet().zoomIn();
        } else if (menuItem.getText().equals(ChartMenuMessages.ZOOMIN_X)) {
            IAxis[] iAxisArray = this.getAxisSet().getXAxes();
            int n = iAxisArray.length;
            int n4 = 0;
            while (n4 < n) {
                IAxis axis = iAxisArray[n4];
                axis.zoomIn();
                ++n4;
            }
        } else if (menuItem.getText().equals(ChartMenuMessages.ZOOMIN_Y)) {
            IAxis[] iAxisArray = this.getAxisSet().getYAxes();
            int n = iAxisArray.length;
            int n5 = 0;
            while (n5 < n) {
                IAxis axis = iAxisArray[n5];
                axis.zoomIn();
                ++n5;
            }
        } else if (menuItem.getText().equals(ChartMenuMessages.ZOOMOUT)) {
            this.getAxisSet().zoomOut();
        } else if (menuItem.getText().equals(ChartMenuMessages.ZOOMOUT_X)) {
            IAxis[] iAxisArray = this.getAxisSet().getXAxes();
            int n = iAxisArray.length;
            int n6 = 0;
            while (n6 < n) {
                IAxis axis = iAxisArray[n6];
                axis.zoomOut();
                ++n6;
            }
        } else if (menuItem.getText().equals(ChartMenuMessages.ZOOMOUT_Y)) {
            IAxis[] iAxisArray = this.getAxisSet().getYAxes();
            int n = iAxisArray.length;
            int n7 = 0;
            while (n7 < n) {
                IAxis axis = iAxisArray[n7];
                axis.zoomOut();
                ++n7;
            }
        } else if (menuItem.getText().equals(ChartMenuMessages.SAVE_AS)) {
            this.openSaveAsDialog();
        } else if (menuItem.getText().equals(ChartMenuMessages.PROPERTIES)) {
            this.openPropertiesDialog();
        }
        this.redraw();
    }

    private void openSaveAsDialog() {
        FileDialog dialog = new FileDialog(this.getShell(), 8192);
        dialog.setText(ChartMenuMessages.SAVE_AS_DIALOG_TITLE);
        dialog.setFilterExtensions(EXTENSIONS);
        dialog.setFileName(this.saveAsFilename);
        String filename = dialog.open();
        if (filename == null) {
            return;
        }
        int format = filename.endsWith(".jpg") || filename.endsWith(".jpeg") ? 4 : (filename.endsWith(".png") ? 5 : -1);
        if (format != -1) {
            this.save(filename, format);
        }
    }

    private void openPropertiesDialog() {
        PreferenceManager manager = new PreferenceManager();
        String chartTitle = Messages.getString("CHART");
        PreferenceNode chartNode = new PreferenceNode(chartTitle);
        chartNode.setPage((IPreferencePage)new ChartPage(this, chartTitle));
        manager.addToRoot((IPreferenceNode)chartNode);
        String legendTitle = Messages.getString("LEGEND");
        PreferenceNode legendNode = new PreferenceNode(legendTitle);
        legendNode.setPage((IPreferencePage)new LegendPage(this, legendTitle));
        manager.addTo(chartTitle, (IPreferenceNode)legendNode);
        String xAxisTitle = Messages.getString("X_AXIS");
        PreferenceNode xAxisNode = new PreferenceNode(xAxisTitle);
        xAxisNode.setPage((IPreferencePage)new AxisPage(this, IAxis.Direction.X, xAxisTitle));
        manager.addTo(chartTitle, (IPreferenceNode)xAxisNode);
        String gridTitle = Messages.getString("GRID");
        PreferenceNode xGridNode = new PreferenceNode(gridTitle);
        xGridNode.setPage((IPreferencePage)new GridPage(this, IAxis.Direction.X, gridTitle));
        manager.addTo(chartTitle + "." + xAxisTitle, (IPreferenceNode)xGridNode);
        String tickTitle = Messages.getString("TICK");
        PreferenceNode xTickNode = new PreferenceNode(tickTitle);
        xTickNode.setPage((IPreferencePage)new AxisTickPage(this, IAxis.Direction.X, tickTitle));
        manager.addTo(chartTitle + "." + xAxisTitle, (IPreferenceNode)xTickNode);
        String yAxisTitle = Messages.getString("Y_AXIS");
        PreferenceNode yAxisNode = new PreferenceNode(yAxisTitle);
        yAxisNode.setPage((IPreferencePage)new AxisPage(this, IAxis.Direction.Y, yAxisTitle));
        manager.addTo(chartTitle, (IPreferenceNode)yAxisNode);
        PreferenceNode yGridNode = new PreferenceNode(gridTitle);
        yGridNode.setPage((IPreferencePage)new GridPage(this, IAxis.Direction.Y, gridTitle));
        manager.addTo(chartTitle + "." + yAxisTitle, (IPreferenceNode)yGridNode);
        PreferenceNode yTickNode = new PreferenceNode(tickTitle);
        yTickNode.setPage((IPreferencePage)new AxisTickPage(this, IAxis.Direction.Y, tickTitle));
        manager.addTo(chartTitle + "." + yAxisTitle, (IPreferenceNode)yTickNode);
        String seriesTitle = Messages.getString("SERIES");
        PreferenceNode plotNode = new PreferenceNode(seriesTitle);
        plotNode.setPage((IPreferencePage)new SeriesPage(this, seriesTitle));
        manager.addTo(chartTitle, (IPreferenceNode)plotNode);
        String labelTitle = Messages.getString("LABEL");
        PreferenceNode labelNode = new PreferenceNode(labelTitle);
        labelNode.setPage((IPreferencePage)new SeriesLabelPage(this, labelTitle));
        manager.addTo(chartTitle + "." + seriesTitle, (IPreferenceNode)labelNode);
        PreferenceDialog dialog = new PreferenceDialog(this.getShell(), manager);
        dialog.create();
        dialog.getShell().setText(Messages.getString("PROPERTIES"));
        dialog.getTreeViewer().expandAll();
        dialog.open();
    }

    private void setRange(Point range, IAxis axis) {
        if (range == null) {
            return;
        }
        double min = axis.getDataCoordinate(range.x);
        double max = axis.getDataCoordinate(range.y);
        axis.setRange(new Range(min, max));
    }
}

