/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.camel.cloud;

import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.eclipse.kura.camel.cloud.KuraCloudComponent;
import org.eclipse.kura.camel.cloud.KuraCloudConsumer;
import org.eclipse.kura.camel.cloud.KuraCloudProducer;
import org.eclipse.kura.camel.internal.cloud.CloudClientCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UriEndpoint(scheme="kura-cloud", title="Kura Cloud", label="iot,kura,cloud", syntax="kura-cloud:applicationId/appTopic")
public class KuraCloudEndpoint
extends DefaultEndpoint {
    private static final Logger logger = LoggerFactory.getLogger(KuraCloudEndpoint.class);
    @UriParam(defaultValue="")
    private String applicationId = "";
    @UriParam(defaultValue="")
    private String topic = "";
    @UriParam(defaultValue="0")
    private int qos;
    @UriParam(defaultValue="false")
    private boolean retain = false;
    @UriParam(defaultValue="5")
    private int priority = 5;
    @UriParam(defaultValue="false")
    private boolean control = false;
    @UriParam(defaultValue="")
    private String deviceId;
    private CloudClientCache.CloudClientHandle cloudClientHandle;
    private final CloudClientCache cache;

    public KuraCloudEndpoint(String uri, KuraCloudComponent kuraCloudComponent, CloudClientCache cache) {
        super(uri, (Component)kuraCloudComponent);
        this.cache = cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStart() throws Exception {
        KuraCloudEndpoint kuraCloudEndpoint = this;
        synchronized (kuraCloudEndpoint) {
            this.cloudClientHandle = this.cache.getOrCreate(this.applicationId);
            logger.debug("CloudClient {} -> {}", (Object)this.applicationId, (Object)this.cloudClientHandle.getClient());
        }
        super.doStart();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStop() throws Exception {
        super.doStop();
        KuraCloudEndpoint kuraCloudEndpoint = this;
        synchronized (kuraCloudEndpoint) {
            if (this.cloudClientHandle != null) {
                this.cloudClientHandle.close();
                this.cloudClientHandle = null;
            }
        }
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        return new KuraCloudConsumer((Endpoint)this, processor, this.cloudClientHandle.getClient());
    }

    public KuraCloudProducer createProducer() throws Exception {
        return new KuraCloudProducer(this, this.cloudClientHandle.getClient());
    }

    public boolean isSingleton() {
        return true;
    }

    public KuraCloudComponent getComponent() {
        return (KuraCloudComponent)super.getComponent();
    }

    public String getTopic() {
        return this.topic;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public int getQos() {
        return this.qos;
    }

    public void setQos(int qos) {
        this.qos = qos;
    }

    public boolean isRetain() {
        return this.retain;
    }

    public void setRetain(boolean retain) {
        this.retain = retain;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public boolean isControl() {
        return this.control;
    }

    public void setControl(boolean control) {
        this.control = control;
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public void setApplicationId(String applicationId) {
        this.applicationId = applicationId;
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }
}

