/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.equinox.permission.cache.fix;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.osgi.service.permissionadmin.PermissionAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EquinoxPermissionCacheCleaner {
    private static final Logger logger = LoggerFactory.getLogger(EquinoxPermissionCacheCleaner.class);
    private static final String CACHE_THRESHOLD_SIZE = "cache.threshold.size";
    private PermissionAdmin permissionAdmin;
    private final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
    private Future<?> cacheClearTask;
    private int cacheThresholdSize;
    private Method permAdminCollectionsMethod;
    private Method condAdminRowsMethod;
    private Object permAdminTable;
    private Object condAdminTable;

    public void setPermissionAdmin(PermissionAdmin permissionAdmin) {
        this.permissionAdmin = permissionAdmin;
    }

    public void activate(Map<String, Object> properties) {
        this.cacheThresholdSize = (Integer)properties.get(CACHE_THRESHOLD_SIZE);
        logger.debug("Permission cache threshold set to {}", (Object)this.cacheThresholdSize);
        try {
            this.loadCacheMethods();
            this.cacheClearTask = this.executor.scheduleWithFixedDelay(this::clearCache, 0L, 30L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            logger.error("Unable to lookup SecurityAdmin methods. Permission cache cleanup disabled.", (Throwable)e);
        }
    }

    private void loadCacheMethods() throws Exception {
        Field permAdminTableField = this.permissionAdmin.getClass().getDeclaredField("permAdminTable");
        permAdminTableField.setAccessible(true);
        Field condAdminTableField = this.permissionAdmin.getClass().getDeclaredField("condAdminTable");
        condAdminTableField.setAccessible(true);
        this.permAdminTable = permAdminTableField.get(this.permissionAdmin);
        this.condAdminTable = condAdminTableField.get(this.permissionAdmin);
        this.permAdminCollectionsMethod = this.permAdminTable.getClass().getDeclaredMethod("getCollections", new Class[0]);
        this.permAdminCollectionsMethod.setAccessible(true);
        this.condAdminRowsMethod = this.condAdminTable.getClass().getDeclaredMethod("getRows", new Class[0]);
        this.condAdminRowsMethod.setAccessible(true);
    }

    private void clearCache() {
        try {
            Object[] permAdminCollections = (Object[])this.permAdminCollectionsMethod.invoke(this.permAdminTable, new Object[0]);
            Object[] condAdminRows = (Object[])this.condAdminRowsMethod.invoke(this.condAdminTable, new Object[0]);
            if (permAdminCollections.length > this.cacheThresholdSize || condAdminRows.length > this.cacheThresholdSize) {
                Method clearCaches = this.permissionAdmin.getClass().getMethod("clearCaches", new Class[0]);
                clearCaches.invoke((Object)this.permissionAdmin, new Object[0]);
                logger.info("Permission cache cleared, Threshold limit of {} exceeded", (Object)this.cacheThresholdSize);
            }
        }
        catch (Exception e) {
            logger.warn("Unable to clear the permission cache", (Throwable)e);
        }
    }

    public void deactivate() {
        if (this.cacheClearTask != null) {
            this.cacheClearTask.cancel(true);
        }
        this.executor.shutdownNow();
    }
}

