/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.internal.wire.h2db.store;

import java.util.Map;
import org.eclipse.kura.type.DataType;
import org.eclipse.kura.util.collection.CollectionUtil;

public final class H2DbDataTypeMapper {
    private static Map<DataType, JdbcType> dataTypeMap = CollectionUtil.newHashMap();
    private static Map<Integer, DataType> jdbcTypeMap = CollectionUtil.newHashMap();

    static {
        dataTypeMap.put(DataType.FLOAT, new JdbcType(6, "FLOAT"));
        dataTypeMap.put(DataType.INTEGER, new JdbcType(4, "INTEGER"));
        dataTypeMap.put(DataType.LONG, new JdbcType(-5, "BIGINT"));
        dataTypeMap.put(DataType.DOUBLE, new JdbcType(8, "DOUBLE"));
        dataTypeMap.put(DataType.BOOLEAN, new JdbcType(16, "BOOLEAN"));
        dataTypeMap.put(DataType.BYTE_ARRAY, new JdbcType(2004, "BLOB"));
        dataTypeMap.put(DataType.STRING, new JdbcType(12, "VARCHAR(102400)"));
        jdbcTypeMap.put(6, DataType.FLOAT);
        jdbcTypeMap.put(4, DataType.INTEGER);
        jdbcTypeMap.put(-5, DataType.LONG);
        jdbcTypeMap.put(8, DataType.DOUBLE);
        jdbcTypeMap.put(16, DataType.BOOLEAN);
        jdbcTypeMap.put(2004, DataType.BYTE_ARRAY);
        jdbcTypeMap.put(12, DataType.STRING);
    }

    private H2DbDataTypeMapper() {
    }

    public static DataType getDataType(int jdbcType) {
        return jdbcTypeMap.get(jdbcType);
    }

    public static JdbcType getJdbcType(DataType dataType) {
        return dataTypeMap.get(dataType);
    }

    public static class JdbcType {
        private final int type;
        private final String typeStr;

        JdbcType(int type, String typeStr) {
            this.type = type;
            this.typeStr = typeStr;
        }

        int getType() {
            return this.type;
        }

        String getTypeString() {
            return this.typeStr;
        }
    }
}

