/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.mqtt;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.mqtt.MqttConnAckMessage;
import io.netty.handler.codec.mqtt.MqttConnAckVariableHeader;
import io.netty.handler.codec.mqtt.MqttConnectMessage;
import io.netty.handler.codec.mqtt.MqttConnectReturnCode;
import io.netty.handler.codec.mqtt.MqttFixedHeader;
import io.netty.handler.codec.mqtt.MqttMessage;
import io.netty.handler.codec.mqtt.MqttMessageIdVariableHeader;
import io.netty.handler.codec.mqtt.MqttMessageType;
import io.netty.handler.codec.mqtt.MqttPubAckMessage;
import io.netty.handler.codec.mqtt.MqttPublishMessage;
import io.netty.handler.codec.mqtt.MqttPublishVariableHeader;
import io.netty.handler.codec.mqtt.MqttQoS;
import io.netty.handler.codec.mqtt.MqttSubAckMessage;
import io.netty.handler.codec.mqtt.MqttSubAckPayload;
import io.netty.handler.codec.mqtt.MqttSubscribeMessage;
import io.netty.handler.codec.mqtt.MqttUnsubAckMessage;
import io.netty.handler.codec.mqtt.MqttUnsubscribeMessage;
import io.netty.util.ReferenceCountUtil;
import org.apache.activemq.artemis.core.protocol.mqtt.MQTTConnection;
import org.apache.activemq.artemis.core.protocol.mqtt.MQTTLogger;
import org.apache.activemq.artemis.core.protocol.mqtt.MQTTProtocolManager;
import org.apache.activemq.artemis.core.protocol.mqtt.MQTTSession;
import org.apache.activemq.artemis.core.protocol.mqtt.MQTTSubscriptionManager;
import org.apache.activemq.artemis.core.protocol.mqtt.MQTTUtil;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.spi.core.protocol.ConnectionEntry;

public class MQTTProtocolHandler
extends ChannelInboundHandlerAdapter {
    private ConnectionEntry connectionEntry;
    private MQTTConnection connection;
    private MQTTSession session;
    private ActiveMQServer server;
    private MQTTProtocolManager protocolManager;
    private ChannelHandlerContext ctx;
    private final MQTTLogger log = MQTTLogger.LOGGER;
    private boolean stopped = false;

    public MQTTProtocolHandler(ActiveMQServer server, MQTTProtocolManager protocolManager) {
        this.server = server;
        this.protocolManager = protocolManager;
    }

    void setConnection(MQTTConnection connection, ConnectionEntry entry) throws Exception {
        this.connectionEntry = entry;
        this.connection = connection;
        this.session = new MQTTSession(this, connection, this.protocolManager, this.server.getConfiguration().getWildcardConfiguration());
    }

    void stop() {
        this.stopped = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        try {
            if (this.stopped) {
                this.disconnect(true);
                return;
            }
            MqttMessage message = (MqttMessage)msg;
            if (message.decoderResult().isFailure()) {
                this.log.debug("Bad Message Disconnecting Client.");
                this.disconnect(true);
                return;
            }
            this.connection.dataReceived();
            MQTTUtil.logMessage(this.session.getState(), message, true);
            this.protocolManager.invokeIncoming(message, this.connection);
            switch (message.fixedHeader().messageType()) {
                case CONNECT: {
                    this.handleConnect((MqttConnectMessage)message, ctx);
                    return;
                }
                case PUBLISH: {
                    this.handlePublish((MqttPublishMessage)message);
                    return;
                }
                case PUBACK: {
                    this.handlePuback((MqttPubAckMessage)message);
                    return;
                }
                case PUBREC: {
                    this.handlePubrec(message);
                    return;
                }
                case PUBREL: {
                    this.handlePubrel(message);
                    return;
                }
                case PUBCOMP: {
                    this.handlePubcomp(message);
                    return;
                }
                case SUBSCRIBE: {
                    this.handleSubscribe((MqttSubscribeMessage)message);
                    return;
                }
                case UNSUBSCRIBE: {
                    this.handleUnsubscribe((MqttUnsubscribeMessage)message);
                    return;
                }
                case PINGREQ: {
                    this.handlePingreq();
                    return;
                }
                case DISCONNECT: {
                    this.disconnect(false);
                    return;
                }
                default: {
                    this.disconnect(true);
                    return;
                }
            }
        }
        catch (Exception e) {
            this.log.debug("Error processing Control Packet, Disconnecting Client", e);
            this.disconnect(true);
            return;
        }
        finally {
            ReferenceCountUtil.release((Object)msg);
        }
    }

    void handleConnect(MqttConnectMessage connect, ChannelHandlerContext ctx) throws Exception {
        this.ctx = ctx;
        this.connectionEntry.ttl = (long)connect.variableHeader().keepAliveTimeSeconds() * 1500L;
        String clientId = connect.payload().clientIdentifier();
        this.session.getConnectionManager().connect(clientId, connect.payload().userName(), connect.payload().passwordInBytes(), connect.variableHeader().isWillFlag(), connect.payload().willMessageInBytes(), connect.payload().willTopic(), connect.variableHeader().isWillRetain(), connect.variableHeader().willQos(), connect.variableHeader().isCleanSession());
    }

    void disconnect(boolean error) {
        this.session.getConnectionManager().disconnect(error);
    }

    void sendConnack(MqttConnectReturnCode returnCode) {
        MqttFixedHeader fixedHeader = new MqttFixedHeader(MqttMessageType.CONNACK, false, MqttQoS.AT_MOST_ONCE, false, 0);
        MqttConnAckVariableHeader varHeader = new MqttConnAckVariableHeader(returnCode, true);
        MqttConnAckMessage message = new MqttConnAckMessage(fixedHeader, varHeader);
        this.sendToClient((MqttMessage)message);
    }

    void handlePublish(MqttPublishMessage message) throws Exception {
        this.session.getMqttPublishManager().handleMessage(message.variableHeader().packetId(), message.variableHeader().topicName(), message.fixedHeader().qosLevel().value(), message.payload(), message.fixedHeader().isRetain());
    }

    void sendPubAck(int messageId) {
        this.sendPublishProtocolControlMessage(messageId, MqttMessageType.PUBACK);
    }

    void sendPubRel(int messageId) {
        this.sendPublishProtocolControlMessage(messageId, MqttMessageType.PUBREL);
    }

    void sendPubRec(int messageId) {
        this.sendPublishProtocolControlMessage(messageId, MqttMessageType.PUBREC);
    }

    void sendPubComp(int messageId) {
        this.sendPublishProtocolControlMessage(messageId, MqttMessageType.PUBCOMP);
    }

    void sendPublishProtocolControlMessage(int messageId, MqttMessageType messageType) {
        MqttQoS qos = messageType == MqttMessageType.PUBREL ? MqttQoS.AT_LEAST_ONCE : MqttQoS.AT_MOST_ONCE;
        MqttFixedHeader fixedHeader = new MqttFixedHeader(messageType, false, qos, false, 0);
        MqttPubAckMessage rel = new MqttPubAckMessage(fixedHeader, MqttMessageIdVariableHeader.from((int)messageId));
        this.sendToClient((MqttMessage)rel);
    }

    void handlePuback(MqttPubAckMessage message) throws Exception {
        this.session.getMqttPublishManager().handlePubAck(this.getMessageId((MqttMessage)message));
    }

    void handlePubrec(MqttMessage message) throws Exception {
        this.session.getMqttPublishManager().handlePubRec(this.getMessageId(message));
    }

    void handlePubrel(MqttMessage message) {
        this.session.getMqttPublishManager().handlePubRel(this.getMessageId(message));
    }

    void handlePubcomp(MqttMessage message) throws Exception {
        this.session.getMqttPublishManager().handlePubComp(this.getMessageId(message));
    }

    void handleSubscribe(MqttSubscribeMessage message) throws Exception {
        MQTTSubscriptionManager subscriptionManager = this.session.getSubscriptionManager();
        int[] qos = subscriptionManager.addSubscriptions(message.payload().topicSubscriptions());
        MqttFixedHeader header = new MqttFixedHeader(MqttMessageType.SUBACK, false, MqttQoS.AT_MOST_ONCE, false, 0);
        MqttSubAckMessage ack = new MqttSubAckMessage(header, message.variableHeader(), new MqttSubAckPayload(qos));
        this.sendToClient((MqttMessage)ack);
    }

    void handleUnsubscribe(MqttUnsubscribeMessage message) throws Exception {
        this.session.getSubscriptionManager().removeSubscriptions(message.payload().topics());
        MqttFixedHeader header = new MqttFixedHeader(MqttMessageType.UNSUBACK, false, MqttQoS.AT_MOST_ONCE, false, 0);
        MqttUnsubAckMessage m = new MqttUnsubAckMessage(header, message.variableHeader());
        this.sendToClient((MqttMessage)m);
    }

    void handlePingreq() {
        MqttMessage pingResp = new MqttMessage(new MqttFixedHeader(MqttMessageType.PINGRESP, false, MqttQoS.AT_MOST_ONCE, false, 0));
        this.sendToClient(pingResp);
    }

    protected void send(int messageId, String topicName, int qosLevel, boolean isRetain, ByteBuf payload, int deliveryCount) {
        boolean redelivery = qosLevel == 0 ? false : deliveryCount > 0;
        MqttFixedHeader header = new MqttFixedHeader(MqttMessageType.PUBLISH, redelivery, MqttQoS.valueOf((int)qosLevel), isRetain, 0);
        MqttPublishVariableHeader varHeader = new MqttPublishVariableHeader(topicName, messageId);
        MqttPublishMessage publish = new MqttPublishMessage(header, varHeader, payload);
        this.sendToClient((MqttMessage)publish);
    }

    private void sendToClient(MqttMessage message) {
        MQTTUtil.logMessage(this.session.getSessionState(), message, false);
        this.protocolManager.invokeOutgoing(message, this.connection);
        this.ctx.write((Object)message);
        this.ctx.flush();
    }

    private int getMessageId(MqttMessage message) {
        return ((MqttMessageIdVariableHeader)message.variableHeader()).messageId();
    }

    ActiveMQServer getServer() {
        return this.server;
    }
}

