/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.internal.ble.eddystone;

public enum EddystoneURLScheme {
    HTTPWWW("http://www.", 0),
    HTTPSWWW("https://www.", 1),
    HTTP("http://", 2),
    HTTPS("https://", 3),
    UKNOWN("", 4);

    private final String urlScheme;
    private final byte urlSchemeCode;
    private final int urlSchemeLength;

    private EddystoneURLScheme(String urlScheme, byte urlSchemeCode) {
        this.urlScheme = urlScheme;
        this.urlSchemeCode = urlSchemeCode;
        this.urlSchemeLength = urlScheme.length();
    }

    public byte getUrlSchemeCode() {
        return this.urlSchemeCode;
    }

    public String getUrlScheme() {
        return this.urlScheme;
    }

    public int getLength() {
        return this.urlSchemeLength;
    }

    public static EddystoneURLScheme encodeURLScheme(String url) {
        EddystoneURLScheme scheme = url.startsWith(EddystoneURLScheme.HTTPWWW.urlScheme) ? HTTPWWW : (url.startsWith(EddystoneURLScheme.HTTPSWWW.urlScheme) ? HTTPSWWW : (url.startsWith(EddystoneURLScheme.HTTP.urlScheme) ? HTTP : (url.startsWith(EddystoneURLScheme.HTTPS.urlScheme) ? HTTPS : UKNOWN)));
        return scheme;
    }

    public static String decodeURLScheme(byte scheme) {
        String prefix = scheme == EddystoneURLScheme.HTTPWWW.urlSchemeCode ? EddystoneURLScheme.HTTPWWW.urlScheme : (scheme == EddystoneURLScheme.HTTPSWWW.urlSchemeCode ? EddystoneURLScheme.HTTPSWWW.urlScheme : (scheme == EddystoneURLScheme.HTTP.urlSchemeCode ? EddystoneURLScheme.HTTP.urlScheme : (scheme == EddystoneURLScheme.HTTPS.urlSchemeCode ? EddystoneURLScheme.HTTPS.urlScheme : EddystoneURLScheme.UKNOWN.urlScheme)));
        return prefix;
    }
}

