/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction.proposals;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.dom.ScopeAnalyzer;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.jdt.internal.ui.text.correction.proposals.LinkedCorrectionProposalCore;

public class CreateObjectReferenceProposalCore
extends LinkedCorrectionProposalCore {
    private ITypeBinding fTypeNode;
    private ASTNode fSelectedNode;
    private String varName = null;
    private String varClass = null;

    public CreateObjectReferenceProposalCore(ICompilationUnit cu, ASTNode selectedNode, ITypeBinding typeNode, int relevance) {
        super("", cu, (ASTRewrite)null, relevance);
        this.fSelectedNode = Objects.requireNonNull(selectedNode);
        this.fTypeNode = Objects.requireNonNull(typeNode);
    }

    public boolean hasProposal() {
        AST ast = this.fSelectedNode.getAST();
        ImportRewrite importRewrite = this.createImportRewrite((CompilationUnit)this.fSelectedNode.getRoot());
        Type newSimpleType = importRewrite.addImport(this.fTypeNode, ast);
        IVariableBinding variabelReference = this.findReference(this.fSelectedNode, newSimpleType);
        if (variabelReference != null) {
            this.varName = variabelReference.getName();
            this.varClass = variabelReference.getType().getName();
            return true;
        }
        return false;
    }

    @Override
    public String getName() {
        return Messages.format(CorrectionMessages.UnresolvedElementsSubProcessor_createnew_reference_to_instance, new Object[]{this.varName, this.varClass});
    }

    @Override
    protected ASTRewrite getRewrite() throws CoreException {
        AST ast = this.fSelectedNode.getAST();
        ImportRewrite importRewrite = this.createImportRewrite((CompilationUnit)this.fSelectedNode.getRoot());
        Type newSimpleType = importRewrite.addImport(this.fTypeNode, ast);
        IVariableBinding findInstance = this.findReference(this.fSelectedNode, newSimpleType);
        if (findInstance == null) {
            return null;
        }
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        if (this.fSelectedNode instanceof ExpressionStatement) {
            ExpressionStatement expressionStatement = (ExpressionStatement)this.fSelectedNode;
            MethodInvocation oldMethodInvocation = (MethodInvocation)expressionStatement.getExpression();
            String methodName = oldMethodInvocation.getName().getIdentifier();
            MethodInvocation newMethodInvocation = ast.newMethodInvocation();
            newMethodInvocation.setName(ast.newSimpleName(methodName));
            newMethodInvocation.setExpression((Expression)ast.newName(findInstance.getName()));
            List arguments = oldMethodInvocation.arguments();
            for (Expression argument : arguments) {
                newMethodInvocation.arguments().add(rewrite.createCopyTarget((ASTNode)argument));
            }
            rewrite.replace((ASTNode)expressionStatement.getExpression(), (ASTNode)newMethodInvocation, null);
            return rewrite;
        }
        if (this.fSelectedNode instanceof QualifiedName) {
            QualifiedName qualifiedName = (QualifiedName)this.fSelectedNode;
            FieldAccess newFieldAccess = ast.newFieldAccess();
            newFieldAccess.setExpression((Expression)ast.newName(findInstance.getName()));
            newFieldAccess.setName(ast.newSimpleName(qualifiedName.getName().getFullyQualifiedName()));
            rewrite.replace((ASTNode)qualifiedName, (ASTNode)newFieldAccess, null);
            return rewrite;
        }
        return null;
    }

    private IVariableBinding findReference(ASTNode node, Type type) {
        BodyDeclaration parent = ASTNodes.getParent(node, BodyDeclaration.class);
        Set<SimpleName> localVariableIdentifiers = ASTNodes.getLocalVariableIdentifiers((ASTNode)parent, true);
        for (SimpleName name : localVariableIdentifiers) {
            String qualifiedTypeName2;
            Type type2 = ASTNodes.getType((VariableDeclaration)name.getParent());
            if (type2 == null || type == null) {
                return null;
            }
            String qualifiedTypeName = ASTNodes.getQualifiedTypeName(type);
            if (!qualifiedTypeName.equals(qualifiedTypeName2 = ASTNodes.getQualifiedTypeName(type2)) || node.getStartPosition() <= name.getStartPosition()) continue;
            if (node instanceof QualifiedName) {
                VariableDeclaration decl;
                Expression initializer;
                if (node.getParent().getStartPosition() <= name.getStartPosition() || !(name.getParent() instanceof VariableDeclaration) || (initializer = (decl = (VariableDeclaration)name.getParent()).getInitializer()) != null && initializer.getNodeType() == 33) continue;
                return ((VariableDeclaration)name.getParent()).resolveBinding();
            }
            return ((VariableDeclaration)name.getParent()).resolveBinding();
        }
        List<IVariableBinding> visibleLocalVariablesInScope = CreateObjectReferenceProposalCore.getVisibleLocalVariablesInScope(this.fSelectedNode);
        for (IVariableBinding binding : visibleLocalVariablesInScope) {
            if (Modifier.isStatic((int)parent.getModifiers()) && !Modifier.isStatic((int)binding.getModifiers()) || !Bindings.equals((IBinding)binding.getType(), (IBinding)this.fTypeNode)) continue;
            return binding;
        }
        return null;
    }

    private static List<IVariableBinding> getVisibleLocalVariablesInScope(ASTNode node) {
        IBinding[] bindings;
        ArrayList<IVariableBinding> variableNames = new ArrayList<IVariableBinding>();
        CompilationUnit root = (CompilationUnit)node.getRoot();
        IBinding[] iBindingArray = bindings = new ScopeAnalyzer(root).getDeclarationsInScope(node.getStartPosition(), 18);
        int n = bindings.length;
        int n2 = 0;
        while (n2 < n) {
            IBinding binding = iBindingArray[n2];
            variableNames.add((IVariableBinding)binding);
            ++n2;
        }
        return variableNames;
    }
}

