/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.greycat;

import greycat.Node;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.eclipse.hawk.core.graph.IGraphEdge;
import org.eclipse.hawk.core.graph.timeaware.ITimeAwareGraphNode;
import org.eclipse.hawk.greycat.GreycatNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GreycatHeavyEdge
implements IGraphEdge {
    private static final Logger LOGGER = LoggerFactory.getLogger(GreycatHeavyEdge.class);
    protected static final String NODETYPE = "h_heavyEdge";
    protected static final String END_REL = "h_end";
    protected static final String START_REL = "h_start";
    protected static final String TYPE_PROP = "h_type";
    private final GreycatNode node;
    private final String type;

    /*
     * Loose catch block
     */
    public static GreycatHeavyEdge create(String type, GreycatNode from, GreycatNode to, Map<String, Object> props) {
        Throwable throwable = null;
        Object var5_6 = null;
        try {
            GreycatHeavyEdge greycatHeavyEdge;
            GreycatNode.NodeReader rEnd;
            GreycatNode.NodeReader rStart;
            block26: {
                rStart = from.getNodeReader();
                rEnd = to.getNodeReader();
                ITimeAwareGraphNode gHeavyEdgeNode = from.getGraph().createNode((Map)props, NODETYPE);
                Throwable throwable2 = null;
                Object var10_14 = null;
                try (GreycatNode.NodeReader rEdge = gHeavyEdgeNode.getNodeReader();){
                    Node heavyEdgeNode = rEdge.get();
                    heavyEdgeNode.set(TYPE_PROP, 2, (Object)type);
                    heavyEdgeNode.addToRelation(START_REL, rStart.get());
                    heavyEdgeNode.addToRelation(END_REL, rEnd.get());
                    GreycatNode.addOutgoing(type, rStart, rEdge);
                    GreycatNode.addIncoming(type, rEnd, rEdge);
                    rEdge.markDirty();
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
                greycatHeavyEdge = new GreycatHeavyEdge((GreycatNode)gHeavyEdgeNode, type);
                if (rEnd != null) {
                    rEnd.close();
                }
                if (rStart == null) break block26;
                rStart.close();
            }
            return greycatHeavyEdge;
            {
                catch (Throwable throwable4) {
                    try {
                        if (rEnd != null) {
                            rEnd.close();
                        }
                        throw throwable4;
                    }
                    catch (Throwable throwable5) {
                        if (throwable == null) {
                            throwable = throwable5;
                        } else if (throwable != throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                        if (rStart != null) {
                            rStart.close();
                        }
                        throw throwable;
                    }
                }
            }
        }
        catch (Throwable throwable6) {
            if (throwable == null) {
                throwable = throwable6;
            } else if (throwable != throwable6) {
                throwable.addSuppressed(throwable6);
            }
            throw throwable;
        }
    }

    public GreycatHeavyEdge(GreycatNode node, String type) {
        this.node = node;
        this.type = type;
    }

    public Object getId() {
        return this.node.getId();
    }

    public String getType() {
        return this.type;
    }

    public Set<String> getPropertyKeys() {
        return this.node.getPropertyKeys();
    }

    public Object getProperty(String name) {
        return this.node.getProperty(name);
    }

    public void setProperty(String name, Object value) {
        this.node.setProperty(name, value);
    }

    public GreycatNode getStartNode() {
        return this.getRawTarget(START_REL);
    }

    public GreycatNode getEndNode() {
        return this.getRawTarget(END_REL);
    }

    public GreycatNode getBackingNode() {
        return this.node;
    }

    public void delete() {
        GreycatNode startNode = this.getStartNode();
        GreycatNode endNode = this.getEndNode();
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try {
                GreycatNode.NodeReader rEdge = this.node.getNodeReader();
                try {
                    GreycatNode.NodeReader rStart = startNode.getNodeReader();
                    try {
                        try (GreycatNode.NodeReader rEnd = endNode.getNodeReader();){
                            String type = this.getType();
                            GreycatNode.removeOutgoing(type, rStart, rEdge);
                            GreycatNode.removeIncoming(type, rEnd, rEdge);
                            Node edgeNode = rEdge.get();
                            if (edgeNode.timeDephasing() > 0L || this.node.getAllVersions().size() > 1) {
                                this.node.travelInTime(this.node.getTime() - 1L).end();
                            } else {
                                this.node.delete();
                            }
                        }
                        if (rStart != null) {
                            rStart.close();
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (rStart != null) {
                            rStart.close();
                        }
                        throw throwable;
                    }
                    if (rEdge != null) {
                        rEdge.close();
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    if (rEdge != null) {
                        rEdge.close();
                    }
                    throw throwable;
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    public void removeProperty(String name) {
        this.node.removeProperty(name);
    }

    protected GreycatNode getRawTarget(String relationName) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (GreycatNode.NodeReader reader = this.node.getNodeReader();){
                CompletableFuture result = new CompletableFuture();
                reader.get().traverse(relationName, targets -> {
                    Node target = targets[0];
                    GreycatNode newNode = this.node.getGraph().lookup(target.world(), target.time(), target.id());
                    Node[] nodeArray = targets;
                    int n = ((Node[])targets).length;
                    int n2 = 0;
                    while (n2 < n) {
                        Node t = nodeArray[n2];
                        t.free();
                        ++n2;
                    }
                    result.complete(newNode);
                });
                return (GreycatNode)result.get();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (InterruptedException | ExecutionException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.node == null ? 0 : this.node.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GreycatHeavyEdge other = (GreycatHeavyEdge)obj;
        return !(this.node == null ? other.node != null : !this.node.equals(other.node));
    }

    public String toString() {
        return "GreycatHeavyEdge [node=" + this.node + ", getStartNode()=" + this.getStartNode() + ", getEndNode()=" + this.getEndNode() + "]";
    }
}

